/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A particle system

    Copyright (c) 1997-1998 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PARTFOUNT_H_
#define INCLUDE_PARTFOUNT_H_

#include "Base/GemBase.h"

#include "Base/Matrix.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS

	partfount
    
	A particle system

DESCRIPTION
    

-----------------------------------------------------------------*/
class GEM_EXTERN partfount : public GemBase
{
    CPPEXTERN_HEADER(partfount, GemBase)

    public:

	    //////////
	    // Constructor
    	partfount();
    	
    	//////////
    	virtual void 	render(GemState *state);

    protected:
    	
    	//////////
    	// Destructor
    	virtual ~partfount();

		//////////
		// The particle group
		int				m_particle;

		//////////
		// The display list
		int				m_dList;

		//////////
		// The current rotation matrix
		Matrix			m_rotMatrix;

		//////////
		// The current bounce matrix
		Matrix			m_bounceMatrix;

		//////////
		int				m_onOff;

		//////////
		// The rotation callback
		void			rotationMess(float x, float y, float z);

		//////////
		// The bounce callback
		void			bounceMess(float x, float y, float z);

		//////////
		void			reset();

		//////////
		void			onOff(int state);

	private:

		//////////
		// Static callbacks
		static void		rotationMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
		static void		bounceMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
        static void     resetCallback(void *data);
        static void     onOffCallback(void *data, t_floatarg state);
};

#endif	// for header file
