/* gdk_t1lib.c: GDK wrappers for t1lib.
   (c) 1998 David Huggins-Daines <bn711@freenet.carleton.ca>
   You may modify and distribute this file under the terms of the GNU
   General Public License, version 2, or any later version, at your
   convenience. See the file COPYING for details. */
  
#include "gdk_t1lib.h"
#include <gdk/gdkx.h>

gpointer gdk_t1lib_init (gint log)
{
  gpointer retval;

  T1_SetBitmapPad( 16);

  if ((retval = T1_InitLib (log)) == NULL){
    return retval;
  }
  
  T1_SetX11Params (GDK_DISPLAY(),
		   GDK_VISUAL_XVISUAL(gdk_visual_get_best()),
		   gdk_visual_get_best_depth(),
		   GDK_COLORMAP_XCOLORMAP(gdk_colormap_get_system()));
  T1_AASetBitsPerPixel (gdk_visual_get_best_depth());
  
  return retval;
}

inline GLYPH *gdk_t1lib_set_char ( GdkDrawable *d, GdkGC *gc, gint mode,
				   gint x_dest, gint y_dest,
				   gint FontID, gchar charcode,
				   gfloat size, gfloat angle)
{
  return T1_SetCharX ( GDK_WINDOW_XWINDOW (d), GDK_GC_XGC (gc), mode,
		x_dest, y_dest, FontID, charcode, size, angle );
}

inline GLYPH *gdk_t1lib_set_string ( GdkDrawable *d, GdkGC *gc,
				     gint mode, gint x_dest, gint y_dest,
				     gint FontID, gchar *string,
				     gint len, glong spaceoff,
				     gint kerning, gfloat size,
				     gfloat angle)
{
  return T1_SetStringX ( GDK_WINDOW_XWINDOW (d), GDK_GC_XGC (gc), mode,
			 x_dest, y_dest, FontID, string, len, spaceoff,
			 kerning, size, angle );
}

/* I hope all the Xlib mucking-around internal to these functions
   doesn't screw up GDK too badly. */

inline GLYPH *gdk_t1lib_set_char_aa ( GdkDrawable *d, GdkGC *gc,
			       gint mode, gint x_dest, gint y_dest,
			       gint FontID, gchar charcode,
			       gfloat size, gfloat angle)
{
  return T1_AASetCharX ( GDK_WINDOW_XWINDOW (d), GDK_GC_XGC (gc), mode,
		x_dest, y_dest, FontID, charcode, size, angle );
}

inline GLYPH *gdk_t1lib_set_string_aa ( GdkDrawable *d, GdkGC *gc,
				 gint mode, gint x_dest, gint y_dest,
				 gint FontID, gchar *string,
				 gint len, glong spaceoff,
				 gint kerning, gfloat size,
				 gfloat angle)
{
  return T1_AASetStringX ( GDK_WINDOW_XWINDOW (d), GDK_GC_XGC (gc), mode,
			   x_dest, y_dest, FontID, string, len, spaceoff,
			   kerning, size, angle );
}
