/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

gint maintain_thumbnail_dir(gchar *dir, gint recursive)
{
	gchar *thumb_dir;
	gint base_length;
	gint still_have_a_file = FALSE;

	if (debug_mode) printf("maintainance check: %s\n", dir);

	base_length = strlen(homedir()) + strlen(THUMBNAIL_CACHE_DIR);
	thumb_dir = g_strconcat(homedir(), THUMBNAIL_CACHE_DIR, dir, NULL);

	if (isdir(thumb_dir))
		{
		DIR             *dp;
		struct dirent   *dirent;
		struct stat ent_sbuf;

		if((dp = opendir(thumb_dir))==NULL)
			{
				/* dir not found */
				g_free(thumb_dir);
				return FALSE;
			}

		while ((dirent = readdir(dp)) != NULL)
			{
			/* skips removed files */
	                if (dirent->d_ino > 0)
	                	{
				int l = 0;
				gchar *path_buf;
				if (strcmp(dirent->d_name, ".") == 0 || strcmp(dirent->d_name, "..") == 0)
					continue;
				path_buf = g_strconcat(thumb_dir, "/", dirent->d_name, NULL);
				if (strlen(path_buf) > 4) l = strlen(path_buf) - 4;

				if (stat(path_buf,&ent_sbuf) >= 0 && S_ISDIR(ent_sbuf.st_mode))
					{
					/* recurse dir then delete it */
					gchar *rdir = g_strconcat(dir, "/", dirent->d_name, NULL);
					if (recursive && !maintain_thumbnail_dir(rdir, TRUE))
						{
						if (debug_mode)
							printf("Deleting thumb dir: %s\n",path_buf);
						if ( (rmdir (path_buf) < 0) )
							printf("Unable to delete dir: %s\n", path_buf);
						}
					else
						still_have_a_file = TRUE;
					g_free(rdir);
					}
				else
					{
					gchar *fp = path_buf + l;
					fp[0] = '\0';
					if (strlen(path_buf) > base_length &&
							!isfile(path_buf + base_length))
						{
						fp[0] = '.';
						if (debug_mode)
							printf("Deleting thumb: %s\n",path_buf);
						if ( (unlink (path_buf) < 0) )
							printf("failed to delete:%s\n",path_buf);
						}
					else
						 still_have_a_file = TRUE;
					}
				g_free(path_buf);
				}
			}
		closedir(dp);
		}
	g_free(thumb_dir);
	return still_have_a_file;
}

void maintain_thumb_cb(GtkWidget *w, gpointer data)
{
	maintain_thumbnail_dir("", TRUE);
}

gint create_thumbnail(gchar *thumb_filename, GdkPixmap **thumb_pixmap, GdkBitmap **thumb_mask)
{
	gint thumb_width,thumb_height;
	gint extra_space;
	GdkImlibImage *thumb = NULL;
	gint was_cached = FALSE;

	/* load thumb */
	if (debug_mode) printf("Thumb:%s\n",thumb_filename);

	/* start load from cache */

	if (ENABLE_THUMB_CACHING)
		{
		gchar *thumb_name;

		thumb_name = g_strconcat(homedir(), THUMBNAIL_CACHE_DIR, thumb_filename, ".png",NULL);

		if (isfile(thumb_name) && filetime(thumb_name) >= filetime(thumb_filename))
			{
			if (debug_mode) printf("Found in cache:%s\n",thumb_name);
			thumb=gdk_imlib_load_image(thumb_name);
			was_cached = TRUE;
			}
		else
			thumb=gdk_imlib_load_image(thumb_filename);
		
		}
	else
		thumb=gdk_imlib_load_image(thumb_filename);

	if (!thumb)
		{
		thumb = gdk_imlib_create_image_from_xpm_data((gchar **)img_unknown_xpm_data);
		was_cached = TRUE; /* no need to save a thumbnail of the unknown pixmap */
		}

	if (thumb)
		{
		if (thumb->rgb_width > thumb_max_width || thumb->rgb_height > thumb_max_height)
			{
			if (((float)thumb_max_width / thumb->rgb_width) < ((float)thumb_max_height / thumb->rgb_height))
				{
				thumb_width = thumb_max_width;
				thumb_height = (float)thumb_width / thumb->rgb_width * thumb->rgb_height;
				if (thumb_height < 1) thumb_height = 1;
				}
			else
				{
				thumb_height = thumb_max_height;
				thumb_width = (float)thumb_height / thumb->rgb_height * thumb->rgb_width;
				if (thumb_width < 1) thumb_width = 1;
				}
			}
		else
			{
			thumb_width = thumb->rgb_width;
			thumb_height = thumb->rgb_height;
			was_cached = TRUE;
			}
		if (*thumb_pixmap) gdk_imlib_free_pixmap(*thumb_pixmap);
		if (*thumb_mask) gdk_imlib_free_bitmap(*thumb_mask);
		*thumb_pixmap = NULL;
		*thumb_mask = NULL;
		gdk_imlib_render(thumb,thumb_width,thumb_height);

	/* start save cache */

		if (ENABLE_THUMB_CACHING && !was_cached)
			{
			gchar *thumb_name;
			gchar *base_dir;
			gchar *thumb_dir;
			GdkImlibImage *save_image = NULL;

			base_dir = g_strconcat(homedir(), THUMBNAIL_CACHE_DIR, NULL);
			if (!isdir(base_dir))
				{
				printf("creating thumbnail dir:%s\n",base_dir);
				if (mkdir(base_dir, 0755) < 0)
					printf("create failed\n");
				}

			thumb_dir = g_strconcat(base_dir, current_dir, NULL);
			if (!isdir(thumb_dir))
				{
				gchar *p = thumb_dir + 1;
				gint l = strlen(thumb_dir);
				while (p < thumb_dir + l)
					{
					if (p[0] == '/')
						{
						p[0] = '\0';
						if (!isdir(thumb_dir))
							{
							if (debug_mode)
								printf("creating sub dir:%s\n",thumb_dir);
							if (mkdir(thumb_dir, 0755) < 0)
								printf("create failed\n");
							}
						p[0] = '/';
						}
					p++;
					}
				if (debug_mode) printf("creating sub dir:%s\n",thumb_dir);
				if (mkdir(thumb_dir, 0755) < 0)
					printf("create failed\n");
				}
			g_free(thumb_dir);

			thumb_name = g_strconcat(base_dir, thumb_filename, ".png", NULL);
			if (debug_mode) printf("Saving thumb: %s\n",thumb_name);

			save_image = gdk_imlib_clone_scaled_image(thumb, thumb_width, thumb_height);
			gdk_imlib_save_image(save_image, thumb_name, NULL);
			gdk_imlib_destroy_image(save_image);

			g_free(base_dir);
			g_free(thumb_name);
			}

	/* end save cache */

		*thumb_pixmap=gdk_imlib_move_image(thumb);
		*thumb_mask=gdk_imlib_move_mask(thumb);
		if (*thumb_pixmap)
			extra_space = thumb_max_width - thumb_width;
		gdk_imlib_destroy_image(thumb);
		thumb = NULL;
		}
	else
		{
		extra_space = -1;
		}
	return extra_space;
}

