/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     bright.c                                                       *
 *            Funktionen zum Ermitteln von Helligkeitsextrema                *
 * Autor:     Andreas Tille                                                  *
 * Datum:     05.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

unsigned long brightness(unsigned char *buf, int x, int y, int step, int storepix)
/* Summe aller Helligkeitswerte im Bildausschnitt
 * --- Parameter: ---
 * unsigned char *buf   : Speicher mit 24Bit Helligkeitswerten
 * int      x           : Breite des zu berechnenden Ausschnittes
 * int      y           : Hhe des zu berechnenden Ausschnittes
 * int      step        : Schritt bis zum Anfang der nchsten Zeile
 *                        (Breite des Originalbildes)
 * int      storepix    : Anzahl der Byte die fr Speicherung eines Pixels bentigt werden
 * --- R"uckgabe: ---
 * unsigned long brightness() : Helligkeitswert des Ausschnitts
 */
{
   register int           sx = x*storepix, sy = step*storepix;
   register unsigned long bright = 0;
   register unsigned char *ap, *fip, *yp, *fiyp;

   for ( fiyp = (yp = buf) + y*sy; yp < fiyp; yp += sy )
      for ( fip = (ap = yp) + sx; ap < fip; ap++ )   /* hier nicht in storepix-Schritten ...    */
         bright += *ap;                              /* schlielich gibts schnelle Rechner ;-) */

   return bright;
}

unsigned long Xsum(unsigned char *buf, int len)
/* Berechnet Summe von aufeinanderfolgenden Bytes
 * --- Parameter: ---
 * unsigned char *buf   : Helligkeitswerte (24 Bit)
 * int      len         : Anzahl der zu summierenden Pixel
 * --- R"uckgabe: ---
 * unsigned long Xsum() : Summe
 */
{
   register unsigned char *ap, *fip;
   register unsigned long sum = 0;

   for ( fip = (ap = buf) + len; ap < fip; ap++ )
      sum += (unsigned long)(*ap);

   return sum;
}

unsigned long Ysum(unsigned char *buf, int len, int step)
/* Berechnet Summe von Bytes, die im Abstand step gespeichert sind  (8-Bit-Version)
 * (Spaltensumme, wenn eine Zeile step Bytes (=storepix*Breite) hat)
 * --- Parameter: ---
 * unsigned char *buf  : Helligkeitswerte (8 Bit)
 * int      len        : Anzahl zu summierender Pixel
 * int      step       : Abstand der Bytes voneinander (Breite des Originals * storepix)
 * --- R"uckgabe: ---
 * unsigned long Ysum(): Summe
 */
{
   register int      s = step;
   register unsigned long sum = 0;   
   register unsigned char *ap, *fip;

   for ( fip = (ap = buf) + len*s; ap < fip; ap += s )
      sum += *ap;
   return sum;
}

unsigned long Ysum3(unsigned char *buf, int len, int step)
/* Berechnet Summe von Bytes, die im Abstand step gespeichert sind  (24-Bit-Version)
 * (Spaltensumme, wenn eine Zeile step Bytes (=storepix*Breite) hat)
 * --- Parameter: ---
 * unsigned char *buf  : Helligkeitswerte (24 Bit)
 * int      len        : Anzahl zu summierender Pixel
 * int      step       : Abstand der Bytes voneinander (Breite des Originals * storepix)
 * --- R"uckgabe: ---
 * unsigned long Ysum(): Summe
 */
{
   register int      s = 3*step;
   register unsigned long sum = 0;   
   register unsigned char *ap, *fip;

   for ( fip = (ap = buf) + len*s; ap < fip; ap += s )
      sum += *ap + *(ap+1) + *(ap+2);
   return sum;
}

void Helligkeiten(PAUL *p, char *file)
/* Calculate brightness of image sets
 * --- Parameter: ---
 * PAUL *p    : list of images, options
 *              used options
 *              f   : extremum or cut
 *              cut : brightness for box dut from image
 * char *file : name of the file to store the brightnesses in
 */
{
   FILE     *fp;
   char     leer[] = "---  ", time[64], fs[64];
   unsigned long bright;
   PICTURE *bild;
   GList   *pl;

   if ( !NBILDER(p->piclist) ) return;

   assert ( (fp = fopen(file, "at")) != NULL );

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( bild->phys == NULL ) {
         strcpy(time, leer);
         strcpy(fs, leer);
      } else {
	 sprintf(time, "%g", bild->phys->t);
	 sprintf(fs, "%g", bild->phys->f_s);
      }
      bright = Xsum(bild->DATA, bild->storepix * bild->W * bild->H);

      fprintf(fp, "%10s  %10lu  %8s  %16s\n", time, bright, fs, bild->file);
      if ( SaveExtrema(p->opt->f) ) {
      } else if ( p->opt->cut ) {
         fprintf(fp, " (%i,%i)(%i,%i)\n", p->opt->cut->x1, p->opt->cut->y1, 
                                          p->opt->cut->x2, p->opt->cut->y2);
      } else
         fputs(" gesamtes Bild.\n", fp);
   }
   fclose(fp);
}

