/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     gray.c                                                         *
 *            make gray images using several methods                         *
 * Autor:     Andreas Tille                                                  *
 * Datum:     25.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

static int MakeSingleGreen(PICTURE *bild, unsigned char eps)
/* create monochrome image from RGB via Gray = (r+g+b)/3 
 * if |r-g| < eps, |r-b| < eps and |g-b| < eps
 * --- Parameter: ---
 * PICTURE  *bild       : list of images
 * unsigned char greps  : threshold up to which RGB differences are accepted
 *                        greps == 255  =>  akzept all
 * --- Rueckgabe: ---
 * int MakeSingleGreen(): 0 fr OK
 */
{
   register int      i, j, k;
   register unsigned char *ap, *fip;
   char                    desc[256];
   
   if ( !IS_PICTURE(bild) ) return -1;

   if ( eps < 255 ) {
      for ( fip = (ap = bild->DATA + 1) + 3*bild->size; ap < fip; ap += 3 ) {
         i = *(ap-1) - *ap;
         j = *ap - *(ap+1);
         k = *(ap+1) - *(ap-1);
         if ( abs(i) > eps || abs(j) > eps || abs(k) > eps ) {
	    /*	    printf("Schranke %i berschritten: R-G=%i, G-B=%i, B-R=%i\n", 
                             eps, i, j, k); */
	    printf("%i: %i, %i, %i\n", (int)(ap - (bild->DATA))/3, 
		   *(ap-1), *ap, *(ap+1));
	    /*	    return 1; */
	 }
         i   = *(ap-1) + *ap + *(ap+1);
	 *ap = (int)i/3;
         *(ap-1) = *(ap+1) = 0;
      }
   } else {
      for ( fip = (ap = bild->DATA + 1) + 3*bild->size; ap < fip; ap += 3 ) {
         i   = *(ap-1) + *ap + *(ap+1);
	 *ap = (int)i/3;
         *(ap-1) = *(ap+1) = 0;
      }
   }
   CopySpec(bild->spec, ChunkNameTyp, TypGray);
   strcpy(desc, "Monochrom via middle of all channels");
   CreateDescription(bild, desc);

   return 0;
}

static int MakeSingleGreenFromChannel(PICTURE *bild, int channel)
/* create monochrome image from one channel
 * --- Parameter: ---
 * PICTURE  *bild                  : list of images
 * int       channel               : 0 = red, 1 = green, 2 = blue
 * --- Return: ---
 * int MakeSingleGreenFromChannel(): 0 fr OK
 */
{
   register unsigned char *ap, *bp, *fip;
   char                    desc[256], *chan[] = {"red", "green", "blue"};

   if ( !IS_PICTURE(bild) ) return -1;
   
   if ( channel != 1 ) {
      bp = bild->DATA + channel;
      for ( fip = (ap = bild->DATA + 1) + 3*bild->size; ap < fip; ap += 3, bp += 3 )
         *ap = *bp;
   }
   for ( fip = (ap = bild->DATA) + 3*bild->size; ap < fip; ap += 3 ) 
      *ap = *(ap+2) = 0;

   CopySpec(bild->spec, ChunkNameTyp, TypGray);
   sprintf(desc, "Monochrom from %s channel", chan[channel]);
   CreateDescription(bild, desc);

   return 0;
}

int MakeGray(PAUL *p)
/* converts RGB-images into gray images
 * --- Parameter: ---
 * PAUL *p         : list of images, options
 *                 : used options:
 *                   greps : allowed noise level, 
 *                   greps == 0  =>  accept all
 * --- return: ---
 * int   MakeGray(): 0 if OK
 */
{
   int      i = 0;
   PICTURE *bild;
   GList   *pl;

   if ( !(p->piclist) ) return 0;

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( IsMonochrom(bild) ) {
	 g_warning("%s is monochrom yet.\n", bild->file);
      } else {
         if ( p->opt->greps < 3 ) 
            i += MakeSingleGreenFromChannel(bild, p->opt->greps);
         else
            i += MakeSingleGreen(bild, p->opt->greps);
         bild->spp   = 1;
         bild->flag |= MAKEGRAY;
         NewFileName(bild, APPGRAY);
      }
   }
   return i;
}

