/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     gtkpaul.c                                                      *
 *            GTK interface for paul                                         *
 * Autor:     Andreas Tille                                                  *
 * Datum:     14.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include "paul.h"
#include "callback.h"
 
#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

const char ANIMATE[] = "Animate",
           STOP[]    = "Stop",
           ACCEPT[]  = "Accept all moved images";

int CreatePicture(PAUL *p)
/* create initial window, define event functions and show window
 */
{
   p->show = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(p->show, BILD(p->piclist)->W, BILD(p->piclist)->H);
   gtk_window_set_title(GTK_WINDOW(p->show), BILD(p->piclist)->file);
  
   gtk_widget_set_events(p->show, 
			 gtk_widget_get_events (p->show) | 
			 GDK_BUTTON_MOTION_MASK |
			 GDK_POINTER_MOTION_HINT_MASK |
			 GDK_BUTTON_PRESS_MASK );
   /*   gtk_window_set_policy(GTK_WINDOW(p->show), TRUE, TRUE, TRUE); */

   gtk_widget_realize(p->show); /* creates the window which is checked in the following test */
   if ( !p->show->window ) {
      g_warning("No valid GdkWindow to show Widget");
      return -1;
   }
   p->activ = p->piclist;
   gtk_widget_show(p->show);
   if ( IsAnimation(p->opt) ) {
      GList *pl = p->piclist;
      int    i = 0;
      do {
	 gtk_list_select_item(GTK_LIST(p->filelist), i++);
      } while ( (pl = pl->next) );
   }
   else
      gtk_list_select_item(GTK_LIST(p->filelist), 0);

   gdk_window_set_hints(p->show->window, 0, 0, 0, 0, 0, 0, GDK_HINT_MIN_SIZE); 
   gtk_signal_connect(GTK_OBJECT(p->show), "key_press_event", GTK_SIGNAL_FUNC(PictureKeyPressed), p);
   return 0;
}

void GtkInterface(PAUL *p)
/* create GTK interface for paul
 */
{
   GtkWidget           *PaulWindow;      /* Menue + main_vbox                         */
   GtkWidget           *p_table,         /* filelist, operation image, animate button */
                       *vbox,            /* vbox containing menubar and p_table       */
                       *menubar;         /* menue                                     */
   GtkAcceleratorTable *accel;
   GtkMenuEntry        *tmp_item,
                        menu_items[] = {
      {"<Main>/File/Open", "<control>O", (GtkMenuCallback)FileLoad, NULL},
      {"<Main>/File/Save", "<control>S", (GtkMenuCallback)FileSave, NULL},
      {"<Main>/File/Save as", "<control>A", (GtkMenuCallback)FileSaveAs, NULL},
      {"<Main>/File/Delete", "<control>D", (GtkMenuCallback)FileDelete, NULL},
      {"<Main>/File/<separator>", NULL, NULL, NULL},
      {"<Main>/File/Info", "<control>I", (GtkMenuCallback)FileInfo, NULL},
      {"<Main>/File/<separator>", NULL, NULL, NULL},
      {"<Main>/File/Quit", "<control>Q", (GtkMenuCallback)PaulExit, NULL},

      {"<Main>/This Image/Contrast & Brightness",            "a",
       (GtkMenuCallback)ThisScaleCallback, NULL},
      {"<Main>/This Image/Cut",                              "c",
       (GtkMenuCallback)ThisCutCallback, NULL},
      {"<Main>/This Image/FFT",                              "t",
       (GtkMenuCallback)ThisFFTCallback, NULL},
      {"<Main>/This Image/Filter",                           "f",
       (GtkMenuCallback)ThisFilterCallback, NULL},
      {"<Main>/This Image/Mirror horizontal",                "w",
       (GtkMenuCallback)ThisMirrorHorizontalCallback, NULL},
      {"<Main>/This Image/Mirror vertical",                  "v", 
       (GtkMenuCallback)ThisMirrorVerticalCallback, NULL},
      {"<Main>/This Image/Histogram",                        "h", 
       (GtkMenuCallback)ThisHistogramCallback, NULL},
      {"<Main>/This Image/Monochrome",                       "g",
       (GtkMenuCallback)ThisMonochromeCallback, NULL},
      {"<Main>/This Image/Negativ",                          "n", 
       (GtkMenuCallback)ThisNegativCallback, NULL},
      {"<Main>/This Image/Rotate  90",                       "x", 
       (GtkMenuCallback)ThisRotate90Callback, NULL},
      {"<Main>/This Image/Rotate 180",                       "y", 
       (GtkMenuCallback)ThisRotate180Callback, NULL},
      {"<Main>/This Image/Rotate 270",                       "z", 
       (GtkMenuCallback)ThisRotate270Callback, NULL},
      {"<Main>/This Image/Remove (white) scanner border",    "s", 
       (GtkMenuCallback)ThisDelScanBorderCallback, NULL},
      {"<Main>/This Image/Remove (black) border",            "r", 
       (GtkMenuCallback)ThisDelBorderCallback, NULL},

      {"<Main>/Marked Images/Contrast & Brightness",         "<shift>A", 
       (GtkMenuCallback)MarkScaleCallback, NULL},
      {"<Main>/Marked Images/FFT",                           "<shift>T", 
       (GtkMenuCallback)MarkFFTCallback, NULL},
      {"<Main>/Marked Images/Filter",                        "<shift>F",
       (GtkMenuCallback)MarkFilterCallback, NULL},
      {"<Main>/Marked Images/Mirror horizontal",             "<shift>W", 
       (GtkMenuCallback)MarkMirrorHorizontalCallback, NULL},
      {"<Main>/Marked Images/Mirror vertical",               "<shift>V", 
       (GtkMenuCallback)MarkMirrorVerticalCallback, NULL},
      {"<Main>/Marked Images/Monochrome",                    "<shift>G",
       (GtkMenuCallback)MarkMonochromeCallback, NULL},
      {"<Main>/Marked Images/Negativ",                       "<shift>N", 
       (GtkMenuCallback)MarkNegativCallback, NULL},
      {"<Main>/Marked Images/Rotate  90",                    "<shift>X", 
       (GtkMenuCallback)MarkRotate90Callback, NULL},
      {"<Main>/Marked Images/Rotate 180",                    "<shift>Y", 
       (GtkMenuCallback)MarkRotate180Callback, NULL},
      {"<Main>/Marked Images/Rotate 270",                    "<shift>Z", 
       (GtkMenuCallback)MarkRotate270Callback, NULL},
      {"<Main>/Marked Images/Remove (white) scanner border", "<shift>S", 
       (GtkMenuCallback)MarkDelScanBorderCallback, NULL},
      {"<Main>/Marked Images/Remove (black) border",         "<shift>R", 
       (GtkMenuCallback)MarkDelBorderCallback, NULL},

      {"<Main>/All Images/Contrast & Brightness",            "<shift><control>A", 
       (GtkMenuCallback)AllScaleCallback, NULL},
      {"<Main>/All Images/Difference",                       "<shift><control>D", 
       (GtkMenuCallback)AllDifferenceCallback, NULL},
      {"<Main>/All Images/FFT",                              "<shift><control>T",
       (GtkMenuCallback)AllFFTCallback, NULL},
      {"<Main>/All Images/Filter",                           "<shift><control>F",
       (GtkMenuCallback)AllFilterCallback, NULL},
      {"<Main>/All Images/Mirror horizontal",                "<shift><control>W",
       (GtkMenuCallback)AllMirrorHorizontalCallback, NULL},
      {"<Main>/All Images/Mirror vertical",                  "<shift><control>V",
       (GtkMenuCallback)AllMirrorVerticalCallback, NULL},
      {"<Main>/All Images/Monochrome",                       "<shift><control>G",
       (GtkMenuCallback)AllMonochromeCallback, NULL},
      {"<Main>/All Images/Move Images accorting to first",   "<shift><control>M",
       (GtkMenuCallback)AllMoveImagesCallback, NULL},
      {"<Main>/All Images/Negativ",                          "<shift><control>N",
       (GtkMenuCallback)AllNegativCallback, NULL},
      {"<Main>/All Images/Rotate  90",                       "<shift><control>X",
       (GtkMenuCallback)AllRotate90Callback, NULL},
      {"<Main>/All Images/Rotate 180",                       "<shift><control>Y",
       (GtkMenuCallback)AllRotate180Callback, NULL},
      {"<Main>/All Images/Rotate 270",                       "<shift><control>Z",
       (GtkMenuCallback)AllRotate270Callback, NULL},
      {"<Main>/All Images/Remove (white) scanner border",    "<shift><control>S",
       (GtkMenuCallback)AllDelScanBorderCallback, NULL},
      {"<Main>/All Images/Remove (black) border",            "<shift><control>R", 
       (GtkMenuCallback)AllDelBorderCallback, NULL},

      {"<Main>/Parameters/Animation time",                   NULL,
       (GtkMenuCallback)AnimationTimeParameterCallback, NULL},
      {"<Main>/Parameters/Border level",                     NULL,
       (GtkMenuCallback)DelBorderParameterCallback, NULL},
      {"<Main>/Parameters/Contrast & Brightness",            NULL,
       (GtkMenuCallback)ScaleParameterCallback, NULL},
      {"<Main>/Parameters/Difference",                       NULL,
       (GtkMenuCallback)DifferenceParameterCallback, NULL},
      {"<Main>/Parameters/Filter size",                      NULL,
       (GtkMenuCallback)FilterParameterCallback, NULL},
      {"<Main>/Parameters/Monochrome",                       NULL,
       (GtkMenuCallback)GrayParameterCallback, NULL},
      {"<Main>/Parameters/Type of moving images",            NULL,
       (GtkMenuCallback)MoveParameterCallback, NULL},
      {NULL, NULL, NULL, NULL}
   };
   int                  nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

   /* to satisfy -pedantic option try this strange initialisation */
   for ( tmp_item = menu_items; tmp_item->path; tmp_item++ ) tmp_item->callback_data = p;
   
   /* create the dialog box */
   PaulWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_signal_connect(GTK_OBJECT(PaulWindow), "destroy", GTK_SIGNAL_FUNC(PaulExit), p);
   gtk_window_set_title(GTK_WINDOW(PaulWindow), exename);
    
   vbox = gtk_vbox_new(FALSE, 1);
   gtk_container_border_width(GTK_CONTAINER(vbox), 3);
   gtk_container_add(GTK_CONTAINER(PaulWindow), vbox);

   get_main_menu(&menubar, &accel, menu_items, nmenu_items);
   gtk_window_add_accelerator_table(GTK_WINDOW(PaulWindow), accel);
   gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);

   p_table = gtk_table_new(4, 1, FALSE);
   gtk_container_add(GTK_CONTAINER(vbox), p_table);
    
   p->w = gtk_scrolled_window_new(NULL, NULL);
   gtk_object_set_user_data(GTK_OBJECT(p->w), NULL);  /* set userdata explicitely NULL */
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(p->w), 
                                  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   gtk_widget_set_usize(p->w, 250, 350);
   gtk_table_attach_defaults(GTK_TABLE(p_table), p->w, 0, 1, 0, 1);
   
   gtk_widget_show_all(PaulWindow);

   CreateGtkListOfImages(p);
   gtk_container_add(GTK_CONTAINER(p->w), (GtkWidget *)p->filelist);
   
   if ( CreatePicture(p) ) {
      g_warning("Cannot create window to show images");
      PaulExit(NULL, p);
   }
  
   if ( p->op ) CreateOperationImageWindow(p);

   if ( NBILDER(p->piclist) > 1 || DoMatchPictures(p->opt->f) ) {
      if ( DoMatchPictures(p->opt->f) ) 
         SetAnimateButton(p, GTK_SIGNAL_FUNC(EndMatchPictures), ACCEPT);
      else if ( IsAnimation(p->opt) ) {
         SetAnimateButton(p, GTK_SIGNAL_FUNC(StopPictureAnimate), STOP);
         PictureAnimate(NULL, p);
      } else {
         SetAnimateButton(p, GTK_SIGNAL_FUNC(PictureAnimate), ANIMATE);
         ButtonSensitive(p);
      }
   }
   gtk_widget_show_all(PaulWindow);
}





