/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     paulinfo.c                                                     *
 *            Ausgabe der in einer Bilddatei enthaltenen Informationen       *
 * Autor:     Andreas Tille                                                  *
 * Datum:     07.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#include "paul.h"

void PaulInfo(GList *piclist, long flag)
/* print image info to stdout
 * --- Parameter: ---
 * GList *piclist: picture list, which should be processed
 * long   flag   : print Gamma curve or not
 */
{
   CHUNK     *cp;
   png_color *gamma, *fip;
   PICTURE   *bild;
   GList     *pl;
   char       GAMMA[] = "Gamma Table";
   
   if ( !NBILDER(piclist) ) return;

   for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
      printf("Filename: %s\n", bild->file);
      printf(" Imagesize: %i x %i = %i\n", bild->W, bild->H, bild->size);
      printf(" Samples per Pixel: %i\n", bild->spp);
      if ( bild->zeit > 0 )
         printf(" Source date: %s", asctime(localtime(&(bild->zeit))));
      for ( cp = bild->spec; cp->key != NULL; cp++ ) 
         if ( cp->value != NULL )
            printf(" %s: %s\n", cp->key, cp->value);
      if ( bild->res ) printf(" Scanner resolution: %i DPI\n", bild->res);
      if ( bild->x_offset != (unsigned long)-1 ) 
         printf(" Scanner offset: (%li,%li) \n", bild->x_offset, bild->y_offset);
      if ( (flag & PRINTGAMMA) && bild->n_gamma && bild->gamma ){
         printf(" %s: %i Werte\n", GAMMA, bild->n_gamma);
         for ( fip = (gamma = bild->gamma) + bild->n_gamma; gamma < fip; gamma++ )
	    printf(" %*c%5i%5i%5i\n", strlen(GAMMA), ' ', 
                   gamma->red, gamma->green, gamma->blue); 
      }
   }
}

