/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * uses:      GTK, Imlib                                                     *
 * Modul:     paulload.c                                                     *
 *            strongly modified load.c from gdk_imlib                        *
 *            new: at_imlib_set_image_from_data() (modified                  *
 *            imlib_create_image_from_data())                                *
 *            Requires Imlib-Version >= 1.4 !!!!!!!!!!!!!!!!!!!!!            *
 * Autor:     Andreas Tille                                                  *
 * Datum:     19.03.1998                                                     *
 * Changes:   19.03.1998: Loading of files was made independent from Imlib   *
 *            Imlib to  get the chance of background image processing        *
 *            without visualisation                                          *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <png.h>
#include <sys/stat.h>
#include <sys/param.h>

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#include "paul.h"

#define HAVE_LIBJPEG
#define HAVE_LIBGIF
#include <gdk_imlib_private.h>

PICTURE *LoadPicture(PICTURE *bild, char *file, long flag)
{
   int            w, h, trans;
   unsigned char *data = NULL;
   char           fil[4096], *sp;
   FILE          *p = NULL;
   struct   stat  stat_buf;

   if ( !file || stat(file, &stat_buf) ) {
      g_warning("File %s doesnt exist.", file);
      return NULL;
   }

   strncpy(fil, file, sizeof(fil));

   if ( (sp = strrchr(file, '.')) ) {
      *(sp++) = 0;
      assert ( (bild->ext = strdup(sp)) );
   } else 
      bild->ext = NULL;
   
   if ( (sp = strrchr(file, '/')) ) {
      *(sp++) = 0;
      assert ( (bild->file = strdup(sp)) );
      assert ( (bild->dir  = strdup(file)) );
   } else {
      assert ( (bild->file = strdup(file)) );
      if ( (sp = getcwd(NULL, MAXPATHLEN)) ) {
         assert ( (bild->dir = strdup(sp)) );
         FREE(sp);
      } else
	 bild->dir = NULL;
   }
   
   trans = 0;
   if      ( gispng(fil)  && !PaulLoadPNG(bild, fil, flag) ) return bild;
   else if ( gistiff(fil) && !PaulLoadTIFF(bild, fil, flag) ) return bild;
   else if ( gisgif(fil) ) data = g_LoadGIF(fil, &w, &h, &trans);
   else if ( gisxpm(fil) ) {
      if ( !id ) {
       /*  g_LoadXPM() requires a valid internal imlib structure!!        *
        *  This wil be simulated by the folowing code                     *
        *  It is enourmous dangerous to do such undocumented stuff!!!!!!  */
         XWindowAttributes   xwa;

         id = (ImlibData *) malloc(sizeof(ImlibData));

         if ( gdk_display ) id->x.disp = gdk_display;
         else               id->x.disp = XOpenDisplay(NULL);;
         id->x.root_cmap = 0;
         if ( XGetWindowAttributes(id->x.disp, DefaultRootWindow(id->x.disp), &xwa) && xwa.colormap )
            id->x.root_cmap = xwa.colormap;

         data = g_LoadXPM(fil, &w, &h, &trans);
         if ( !gdk_display ) XCloseDisplay(id->x.disp);
         free(id);
	 id = NULL;
      } else
         data = g_LoadXPM(fil, &w, &h, &trans);
   }
   else if ( gisbmp(fil) ) data = g_LoadBMP(fil, &w, &h, &trans);
   else if ( gisjpeg(fil) && (p = fopen(fil, "rb"))) {
      data = g_LoadJPEG(p, &w, &h);
      fclose(p);
   } 
   else if ( gispnm(fil) && (p = fopen(fil, "rb")) ) {
         data = g_LoadPPM(p, &w, &h);
         fclose(p);
      }
   if (!data && (p = open_helper("%C/convert %s pnm:-", fil, "rb")) ) {
      data = g_LoadPPM(p, &w, &h);
      close_helper(p);
   }

   if ( !data ) {
      fprintf(stderr, "ERROR: Cannot load image: %s\nAll fallbacks failed.\n", fil);
      free(bild->file);
      return NULL;
   }
   bild->DATA = data;
   bild->size = (bild->W = w) * (bild->H = h);
   
   GetPictureSpecs(bild, fil);

   return bild;
}


GdkImlibImage *at_imlib_set_image_from_data(unsigned char *data, gint w, gint h)
{
   GdkImlibImage *im;
   char           s[128];
   
   if ( !data || w <=0 || h <= 0 ) return NULL;
   if ( id == NULL ) {
      g_warning("gdk_imlib_init() wasn't called!");
      return NULL;
   }
   assert ( (im = malloc(sizeof(GdkImlibImage))) );
   im->rgb_width      = w;
   im->rgb_height     = h;
   im->rgb_data       = data;
   im->alpha_data     = NULL;
   g_snprintf(s, sizeof(s), "creat_%x_%x", (int)time(NULL), (int)rand());
   if ( (im->filename = malloc(strlen(s) + 1)) ) strcpy(im->filename, s);
   im->width          = 0;
   im->height         = 0;
   im->shape_color.r  = -1;
   im->shape_color.g  = -1;
   im->shape_color.b  = -1;
   im->border.left    = 0;
   im->border.right   = 0;
   im->border.top     = 0;
   im->border.bottom  = 0;
   im->pixmap         = NULL;
   im->shape_mask     = NULL;
   im->cache          = 1;
   im->mod.gamma      = id->mod.gamma;
   im->mod.brightness = id->mod.brightness;
   im->mod.contrast   = id->mod.contrast;
   im->rmod.gamma     = id->rmod.gamma;
   im->rmod.brightness= id->rmod.brightness;
   im->rmod.contrast  = id->rmod.contrast;
   im->gmod.gamma     = id->gmod.gamma;
   im->gmod.brightness= id->gmod.brightness;
   im->gmod.contrast  = id->gmod.contrast;
   im->bmod.gamma     = id->bmod.gamma;
   im->bmod.brightness= id->bmod.brightness;
   im->bmod.contrast  = id->bmod.contrast;
   if (id->cache.on_image) gadd_image(im,im->filename);
   gcalc_map_tables(im);
   return im;
}
