/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     pngload.c                                                      *
 *            Laden von PNG Bildern unter Bercksichtigung spezifischer      *
 *            Chunks                                                         *
 * Autor:     Andreas Tille                                                  *
 * Datum:     18.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <png.h>
#include <stdlib.h>
#include <setjmp.h>

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#include "paul.h"

int PaulLoadPNG(PICTURE *bild, char *file, long flag)
/* Liest PNG-Datei
 * --- Parameter: ---
 * PICTURE       *bild         : Bildstruktur
 * char          *file         : Dateiname (Nur zum ermitteln von bild->source bentigt!!)
 * --- R"uckgabe: ---
 * PICTURE       *bild         : gelesenes Bild
 * int           *PaulLoadPNG(): 0 fr OK
 */
{
   png_struct *png_ptr;
   png_info   *info_ptr;
   unsigned    char *ptr, **lines, *ptr2, r, g, b, a;
   unsigned    char *img_buf;
   int         i, x, y;
   register    unsigned char *ap = NULL, *fip = NULL, **app = NULL, **fipp = NULL;
   png_text   *chunks, *cp, *fcp;
   png_time   *zeit;
   png_color  *gamma;
   FILE       *f;

   if ( !(f = fopen(file, "rb")) ) return -1;
   /* Init PNG Reader */
   if ( !(png_ptr=png_create_read_struct(PNG_LIBPNG_VER_STRING,NULL,NULL,NULL)) )
      return -1;
   if ( !(info_ptr=png_create_info_struct(png_ptr)) ) {
      png_destroy_read_struct(&png_ptr,NULL,NULL);
      return -1;
   }
/* seems to be outdated !!!!!!!!!
   if ( setjmp(png_ptr->jmpbuf) ) {
      png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
      return -1;
   }
*/
   if ( info_ptr->color_type == PNG_COLOR_TYPE_RGB_ALPHA ) {
      png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
      return -1;
   }
 
   png_init_io(png_ptr,f);
   /* Read Header */
   png_read_info(png_ptr,info_ptr);

   /* erster Versuch, ein Graubild zu erkennen ... da ist noch mehr drin! */
   if ( (i = png_get_color_type(png_ptr, info_ptr)) == PNG_COLOR_TYPE_GRAY )
      bild->spp   = 1;
   else
      bild->spp   = 3;
   /* Setup Translators */
   if (info_ptr->color_type==PNG_COLOR_TYPE_PALETTE) png_set_expand(png_ptr);
   if (info_ptr->color_type==PNG_COLOR_TYPE_GRAY) png_set_expand(png_ptr);
   if (info_ptr->bit_depth==16) png_set_strip_16(png_ptr);
   if (png_get_valid(png_ptr,info_ptr,PNG_INFO_tRNS))
     png_set_expand(png_ptr);
   png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);
   bild->trans=0;
   bild->W = png_get_image_width(png_ptr, info_ptr);
   bild->H = png_get_image_height(png_ptr, info_ptr);
   bild->size = bild->W * bild->H;

   if ( png_get_text(png_ptr, info_ptr, &chunks, &i) ) {
      for ( fcp = (cp = chunks) + i; cp < fcp; cp++ ) {
         if ( CopySpec(bild->spec, cp->key, cp->text) ) 
            fprintf(stderr, "Unbekannter Key \"%s\": %s\n", cp->key, cp->text);
      }
   }

   if ( png_get_tIME(png_ptr, info_ptr, &zeit) ) 
      bild->zeit = convert_png_time_to_time_t(zeit);
   GetPictureSpecs(bild, file);

   if ( png_get_valid(png_ptr, info_ptr, PNG_INFO_pHYs) && 
        info_ptr->x_pixels_per_unit == info_ptr->y_pixels_per_unit ) /* sonst kann ja jeder kommen */
      bild->res = info_ptr->x_pixels_per_unit;
   if ( png_get_valid(png_ptr, info_ptr, PNG_INFO_oFFs) ) {
      png_get_oFFs(png_ptr, info_ptr, &(bild->x_offset), &(bild->y_offset), &i);
      if ( i != PNG_OFFSET_PIXEL )
         fputs("Verdchtige Einheit bei Scanneroffset!\n", stderr);
   }
   if ( PNG_INFO_PLTE != png_get_PLTE(png_ptr, info_ptr, &gamma, &(bild->n_gamma)) &&
        png_get_valid(png_ptr, info_ptr, PNG_INFO_PLTE) )
      fputs("Fehler beim Lesen der Gamma Tabelle!\n", stderr);
   else if ( bild->n_gamma ) {
      png_color *gap, *gip;
      assert ( (bild->gamma = malloc(bild->n_gamma * sizeof(png_color))) );
      for ( gip = gamma + bild->n_gamma, gap = bild->gamma; gamma < gip; gamma++, gap++ ) {
          gap->red   = gamma->red;
          gap->green = gamma->green;
          gap->blue  = gamma->blue;
      }
   }
   if ( OnlyInfo(flag) ) {
      bild->DATA = NULL;
      png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
      fclose(f);
      return 0;
   }
   if ( !(bild->DATA=malloc(3*bild->size)) ) {
      png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
      return -1;
   }

   if ( bild->spp == 1 ) i = png_get_rowbytes(png_ptr, info_ptr);
   else                  i = 4*bild->W; /* needed for working Imlib Algorithm */
   /* auf diese Weise gehen noch einige monochrome Bilder durch die Lappen,   *
    * aber was solls                                                         */

   lines=(unsigned char **)malloc(bild->H*sizeof(unsigned char *));
   if ( (img_buf = malloc(bild->H * i)) == NULL ) {
      png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
      return -1;
   }
   for ( fipp = (app = lines) + bild->H, ap = img_buf; 
         app < fipp; app++, ap += i ) 
      *app = ap;

   png_read_image(png_ptr,lines);
   png_destroy_read_struct(&png_ptr,&info_ptr,NULL);
   ptr=bild->DATA;
   if ( IsMonochrom(bild) ) {
      memset(ptr, 0, 3*bild->size);
      ptr++;            /* Grn */
      for (fipp = (app = lines) + bild->H; app < fipp; app++ )
         for ( fip = ptr + 3*bild->W, ap = *app; ptr < fip; ptr += 3, ap++ )
            *ptr = *ap;
   } else {
      for (y = 0; y < bild->H; y++) {
	 ptr2 = lines[y];
	 for(x = 0; x < bild->W; x++) {
	    r = *ptr2++;
            g = *ptr2++;
            b = *ptr2++;
            a=*ptr2++;
	    if (a < 128) {
	       *ptr++ = 255;
               *ptr++ = 0;
               *ptr++ = 255;
	       bild->trans=1;
	    } else {
	       if ((r==255)&&(g==0)&&(b==255)) r=254;
	       *ptr++ = r;
               *ptr++ = g;
               *ptr++ = b;
	    }
	 }
      }
   }
   free(img_buf);
   free(lines);
   fclose(f);
   return 0;
}

