/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     tifsave.c                                                      *
 *            Schreiben von TIFF-Dateien                                     *
 * Autor:     Andreas Tille                                                  *
 * Datum:     30.03.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <tiffio.h>
#include <stdlib.h>
#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

int GetTag(char *key)
/* Liefert Nummer des zu key korrespondierenden TAGS
 * --- Parameter: ---
 * char *key    : Key des gesuchten Chunks
 * --- R"uckgabe: ---
 * int  GetTag(): Nummer des zu key korrespondierenden TAGS
 */
{
   typedef struct { char *key; int tag; } TAG_HASH;
   TAG_HASH table[] = { {ChunkNameSource,      TIFFTAG_DOCUMENTNAME},
		        {ChunkNameSoftware,    TIFFTAG_SOFTWARE},
                        {ChunkNameDescription, TIFFTAG_IMAGEDESCRIPTION},
                        {ChunkNameAuthor,      TIFFTAG_ARTIST},
                        {ChunkNameTyp,         TIFFTAG_MODEL},
                        {ChunkFilmType,        TIFFTAG_HOSTCOMPUTER},
                        {ChunkBrightness,      TIFFTAG_PAGENUMBER},
                        {ChunkContrast,        TIFFTAG_HALFTONEHINTS},
                        {ChunkReferenceFile,   TIFFTAG_MAKE},
                        {NULL,                 -1}
                      },
	     *ap;

    for ( ap = table; ap->key != NULL; ap++ ) 
       if ( !strcmp(ap->key, key) ) return ap->tag;
    fprintf(stderr, "Keine TAG-Entsprechung fr Chunk %s\n", key);
    return -1;
}


int WriteTIFFImage(PICTURE *bild, char *filename)
/* write TIFF files
 * --- Parameter: ---
 * PICTURE *bild        : image to write
 * char    *filename    : name of TIFF file (may differ from bild->file)
 * --- Return: ---
 * int WriteTIFFImage() : 0 if OK
 */
{
   TIFF      *tiff;
   register   unsigned char *ap, *sp;
   unsigned   char *scanline, *fip;
   int        scanlinesize, y;
   CHUNK     *cp;
   struct tm *tmp;
   char       buf[32];
   short      sval;
  
printf("WriteTIFFImage %s\n", filename);
   if ( (tiff = TIFFOpen(filename, "w")) == NULL ) return -1;

   TIFFSetField(tiff, TIFFTAG_IMAGELENGTH,     (uint32) bild->H);
   TIFFSetField(tiff, TIFFTAG_IMAGEWIDTH,      (uint32) bild->W);
   TIFFSetField(tiff, TIFFTAG_BITSPERSAMPLE,   8);

   /* COMPRESSION_CCITTRLE, COMPRESSION_CCITTFAX[34], COMPRESSION_CCITTRLEW
    *  --> Bits/sample must be 1 for Group 3/4 encoding/decoding.           */
   /* TIFFSetField(tiff, TIFFTAG_COMPRESSION,     COMPRESSION_PACKBITS);    *
    *  --> fast keine Kompression                                           */
   /* TIFFSetField(tiff, TIFFTAG_COMPRESSION,     COMPRESSION_LZW);         *
    *  --> nicht so doll                                                    */
   TIFFSetField(tiff, TIFFTAG_COMPRESSION,     COMPRESSION_DEFLATE);
   /* auch nicht berauschend, aber noch am besten von den getesteten */

   TIFFSetField(tiff, TIFFTAG_PLANARCONFIG,    PLANARCONFIG_CONTIG);
   TIFFSetField(tiff, TIFFTAG_SAMPLESPERPIXEL, bild->spp);
   TIFFSetField(tiff, TIFFTAG_ROWSPERSTRIP,    bild->H);

   if ( bild->spec ) 
      for ( cp = bild->spec; cp->key != NULL; cp++ ) {
         if ( cp->value ) {
            y = GetTag(cp->key);
            if ( TIFFTAG_PAGENUMBER == y || TIFFTAG_HALFTONEHINTS == y) {
               if ( 1 == sscanf(cp->value, "%hi", &sval) ) {
	          TIFFSetField(tiff, y, sval);
                  continue;
               }
            }
            if ( y >= 0 ) TIFFSetField(tiff, y, cp->value); 
	 }
      }

   if ( !(bild->zeit) ) bild->zeit = time(NULL);
   tmp = gmtime(&(bild->zeit));
   sprintf(buf, "%04i:%02i:%02i %02i:%02i:%02i",
	   1900+tmp->tm_year, 1+tmp->tm_mon, tmp->tm_mday, 
           tmp->tm_hour, tmp->tm_min, tmp->tm_sec);
   TIFFSetField(tiff, TIFFTAG_DATETIME, buf);
   if ( bild->res ) {
      TIFFSetField(tiff, TIFFTAG_XRESOLUTION, (float)bild->res);
      TIFFSetField(tiff, TIFFTAG_YRESOLUTION, (float)bild->res);
      TIFFSetField(tiff, TIFFTAG_RESOLUTIONUNIT, RESUNIT_INCH);
   }
   if ( bild->x_offset != (unsigned long)-1 ) {
      TIFFSetField(tiff, TIFFTAG_XPOSITION, (float)bild->x_offset);
      TIFFSetField(tiff, TIFFTAG_YPOSITION, (float)bild->y_offset);
   }

   scanlinesize = TIFFScanlineSize(tiff);
   if ( bild->storepix == 3 ) {
      if ( (scanline=malloc(scanlinesize)) == NULL) return -1;
      if ( IsMonochrom(bild) ) {
         for ( ap = bild->DATA + 1, y = 0; y < bild->H; y++ ) {
            for ( fip = (sp = scanline) + scanlinesize; sp < fip; sp++, ap += 3)
               *sp = *ap;
            if ( TIFFWriteScanline(tiff, scanline, y, 0) < 0 ) {
               fprintf(stderr, "TIFFWriteScanline() - Error\n");
               break;
            }
         }
      } else {
         for ( fip = (ap = bild->DATA) + 3*bild->size, y = 0; ap < fip; 
               y++, ap += scanlinesize ) {
            if ( TIFFWriteScanline(tiff, ap, y, 0) < 0 ) break;
         }
      }
      free(scanline);
   } else {
      for ( ap = bild->DATA, y = 0; y < bild->H; y++, ap += scanlinesize ) 
         if ( TIFFWriteScanline(tiff, ap, y, 0) < 0 ) {
            fprintf(stderr, "TIFFWriteScanline() - Error\n");
            break;
         }
   }

   TIFFWriteDirectory(tiff);
   TIFFClose(tiff);
   return 0;
}

