.TH PHOTOPC 1 "24 May 1997" "PhotoPC manipulation tool" "User Commands"
.SH NAME

photopc \- utility to control Agfa, Epson, Olympus and Sanyo digital cameras

.SH SYNOPSIS

photopc [-h] [-v[v]] [-f timeformat] [-s <speed>] [-l <device>] [command [params] ] ...

.SH DESCRIPTION

This is a command line tool to manipulate digital still cameras that use
a certain control protocol, namely Agfa ePhoto line, Epson PhotoPC line,
Olympus D-xxxL line and Sanyo cameras.  It can set camera parameters,
download and erase pictures, e.t.c.  It is only really tested with Epson
PhotoPC 500, though.

.PP
.SH "OPTIONS"

.TP 0.5i
.B -h
This option produces a help screen of all options and commands.

.TP 0.5i
.B -v
This option enables verbose output. Using two -v options increases the
level of verbosity. This is primarily meant for debugging.

.TP 0.5i
.B -q
This option sets quite mode.  If it is not specified, the program will
show running download progress indicator.

.TP 0.5i
.B -s speed
This option allows setting the data rate to use when communicating with
the camera.  Valid rates are 9600, 19200, 38400, 57600 and 115200 (the
default).

.TP 0.5i
.B -f timeformat
This option allows to specify the format for automatically generated
image file names; the value is used as the format string for
strftime(3) function.  By default, names of the format "MMDD_NNN.jpg"
are generated, where MM is a month, DD is a day, and NNN is a count
starting from 001.  A good starting point for the timeformat value
could be "%Y_%m_%d-%H:%M:%S.jpg".  If the format string contains
context "%%XXXd" where XXX are digits, it is taken for the count,
i.e. if the file with such name is present, next count is tried.

A few single-character formats are used as shortcuts.  "x" makes the
name of seconds since the epoch in hexadecimal format (8 characters +
".jpg"), "d" - the same in decimal format (10 characters), "1" stands
for default format "%m%d_%%03d.jpg", "2" stands for "%y%m%d%%02d.jpg",
"3" stands for "%Y_%m_%d-%H:%M:%S.jpg" and 4 stands for
"%Y/%m/%d/%H:%M:%S.jpg".  The program attempts to create intermediate
directories is necessary.

.TP 0.5i
.B -l device
This allows specifying the serial device to use for communicating with
the camera. The default is /dev/photopc (which is typically created as
a (symbolic) link to the real device, e.g. /dev/cua1).

.SH COMMANDS

After the options, one or more commands can be given on the command line.

.TP 0.5i
.B query
Display all current camera settings.

.TP 0.5i
.B count
Output the number of pictures stored in the camera.  This is intended
for use in shell scripts.

.TP 0.5i
.B list
List information about frames stored in the camera.  Fields displayed
are: frame number, protection state, size of image file, resolution
mode, flash, shutter and timestamp.

.TP 0.5i
.B protect On | Off <frame-number>
Change "protected" status of a single frame. Frame numbering starts at
1. The command will fail if the frame number is omitted, not numeric, or
does not correspond to a stored frame.  "Protected" frames cannot be
erased with "erase" and "eraseall" commands or with the "erase" button
on the camera.

.TP 0.5i
.B erase <frame-number>
Erase a single frame. Frame numbering starts at 1. The command will fail
if the frame number is omitted, not numeric, or does not correspond to a
stored frame.

.TP 0.5i
.B eraseall
Erase all stored frames.

.TP 0.5i
.B snapshot
Take a picture.

.TP 0.5i
.B off
Switch off the camera.  This command only has this effect on some models
(notably Olympus D-600L).  On other models, it just terminate the
session immediately (otherwise the camera would be active several
seconds after the last command).  On models with big timeout, such as
Photopc 600, it may be wise to always issue "off" at the end of command
row, to decrease power consumption.

All commands going after "off" are ignored.

.TP 0.5i
.B image <frame-interval> <file-or-dir-name>
Download an image or series of images from the camera to disk file(s) on
the host computer.  Frame numbering starts at 1. The command will fail
if the frame number is omitted, not numeric, or does not correspond to a
stored frame.  Files are stored in JPEG (JFIF) format.  Image file also
contains a thumbnail portion, and set of parameters like the shutter
speed, date and time, I.D. string and more.  Frame interval is a word
.B all
, or a single number, or two numbers separated by a dash (-),
without whitespace.  If directory name is specified, downloaded file(s)
will get unique names starting with month and date of snapshot,
unless -f option is used.
Directory must be specified if frame interval is requested.

.TP 0.5i
.B thumbnail <frame-interval> <file-or-dir-name>
Download a thumbnail image or series of thumbnails from the camera to
disk file(s) on the host computer. Frame numbering starts at 1. The
command will fail if the frame number is omitted, not numeric, or does
not correspond to a stored frame. Files are stored in JPEG (JFIF)
format.  Thumbnail file also contains a set of parameters like the
shutter speed, date and time, I.D.  string and more.  Frame interval is
a word
.B all
, or a single number, or two numbers separated by a dash
(-), without whitespace.  If directory name is specified, downloaded
file(s) will get unique names starting with month and date of snapshot,
unless -f option is used.
Directory must be specified if frame interval is requested.

.TP 0.5i
.B upload <file-name>
Upload image file into the camera.

.B WARNING!
You cannot upload arbitrary JFIF file.  Depending on the camera model,
such attempt may result in the image not uploaded, not viewable, or even
the camera "hung" needing to remove the batteries to make it work again.
File previously downloaded from the same camera model is always uploadable.
Otherwise, your milage may vary.
.B photopc
program does not perform any checks, so it's up to the user to provide
the file in proper format.

.TP 0.5i
.B resolution Hi | Lo | Ext
Set the camera to high, low or extended resolution mode.  Exact meaning
of the modes is model-dependant and may specify different image
dimensions and/or JPEG compression rate.

.TP 0.5i
.B clock
Set the camera's internal real-time clock using the current date and
time from the host computer.  Time of taking a snapshot is included
inside the JPEG files produced.

.TP 0.5i
.B shutter <speed>
Set the camera shutter speed.  Units can be specified in microseconds or
in traditional form like "1/250".  Valid interval for PhotoPC 500 is
from 1/8 to 1/10000.  If a value outside the interval is specified, the
camera will set the speed to the nearest margin of the valid interval.
Special speed value
.B auto
will set automatic shutter.  Note that this only works
while the camera is connected to the host, and automatically turns the
flash off.  While disconnected, shutter speed is always set
automatically.  Also note that there is no known way to control the
aperture.

.TP 0.5i
.B flash Auto | Force | Off | AntiRedeye
Set the camera flash mode.

.TP 0.5i
.B id <string>
Set the camera identifier string that is included inside the JPEG files
produced.

.TP 0.5i
.B autoshut-host <seconds>
Automatically shut off the camera after that many seconds of inactivity
while connected to the computer (on the host).

.TP 0.5i
.B autoshut-field <seconds>
Automatically shut off the camera after that many seconds of inactivity
while disconnected from the computer (in the field).

.TP 0.5i
.B lcd-autoshut <seconds>
Automatically shut off the LCD monitor after that many seconds of inactivity.

.TP 0.5i
.B lcd-brightness <value>
Set LCD brightness to the value (valid values are 1 to 7).

.TP 0.5i
.B macro On | Off
Set the lens macro mode.  As far as I can tell, macro mode only means
force minimum aperture, not change the focal length.

.TP 0.5i
.B color On | Off
Set color or B/W mode.

.SH EXAMPLES

% photopc query

% photopc -f "image%H:%M:%S" eraseall snapshot image 1 .

.SH OTHER NOTES

The software was tested with PhotoPC 500, and should work with other
Epson models as well as with Agfa, Olympus and Sanyo digital cameras.

The latest version of this tool can be found at
ftp://ftp.average.org/pub/photopc/; see also WWW page at
http://www.average.org/digicam/.

Trademarks are properties of their respective owners.

.SH COPYRIGHT

The program is copyrighted by Eugene G. Crosser <crosser@average.org>
and freely distributable.  See README file for detailes.  DOS and
Windows support copyright Bruce D. Lightner <lightner@metaflow.com>

.SH CREDITS

The man page was originally written by Jeff Tranter
<jeff_tranter@pobox.com>, who also contributed a few bugfixes.  Some
information about the serial protocol obtained from Jun-ichiro "itojun"
Itoh <itojun@itojun.org> and other contributors.

.SH SEE ALSO

epinfo(1), strftime(3), PhotoPC protocol description
(protocol.html in the distribution).
