#ifndef lint
static char SccsId[] = "%W%  %G%";
#endif

/* Module:	imglogo.c
 * Purpose:	Put logo in image buffer
 * Subroutine:	color_logo()	returns: void
 * Subroutine:	load_logo()	returns: void
 * Xlib calls:	none
 * Copyright:	1989 Smithsonian Astrophysical Observatory
 *		You may do anything you like with this file except remove
 *		this copyright.  The Smithsonian Astrophysical Observatory
 *		makes no representations about the suitability of this
 *		software for any purpose.  It is provided "as is" without
 *		express or implied warranty.
 * Modified:    {0} Michael VanHilst	initial version		25 April 1990
 */

/* image values of various features of the logo */
#define SUNN 201
#define SURND 1
#define BKGD 200
#define LET 0

/* dimensions of the uncoded and code logo image */
#define LOGO_WIDTH 176
#define LOGO_HEIGHT 197
#define LOGO_SZ 3444

/*
 * Subroutine:	color_logo
 * Purpose:	redirect lookup table to map parts of logo to static colors
 */
void color_logo ( lookup, blue, yellow )
     unsigned char *lookup;
     int blue;
     int yellow;
{
  lookup[SURND] = (unsigned char)blue;
  lookup[SUNN] = (unsigned char)yellow;
}

/*
 * Subroutine:	make_logo
 * Purpose:	decode run-length encoded saoimage logo into short buffer
 */
static void make_logo ( logo, logo_len, buf, buf_width )
     register unsigned char *logo;
     int logo_len;
     short *buf;
     int buf_width;
{
  int i, j, val, cnt;
  register int x;
  int run, line;
  register short *ob;
  unsigned char *logo_end;

  logo_end = logo + logo_len;
  while( logo < logo_end ) {
    line = *logo;
    logo++;
    cnt = *logo;
    logo++;
    ob = &buf[line * buf_width];
    x = 0;
    for( i = 0; i < cnt; i++ ) {
      run = *logo;
      logo++;
      val = *logo;
      logo++;
      for( j=0; j<run; j++ ) {
	*ob = val;
	ob++;
	x++;
      }
    }
  }
}

static unsigned char logo[LOGO_SZ] = {
 0x00, 0x02, 0x53, 0xc8, 0x0c, 0x01, 0x01, 0x02, 0x4b, 0xc8, 0x1c, 0x01,
 0x02, 0x02, 0x46, 0xc8, 0x26, 0x01, 0x03, 0x02, 0x42, 0xc8, 0x2e, 0x01,
 0x04, 0x02, 0x3f, 0xc8, 0x34, 0x01, 0x05, 0x02, 0x3c, 0xc8, 0x3a, 0x01,
 0x06, 0x02, 0x3a, 0xc8, 0x3e, 0x01, 0x07, 0x02, 0x37, 0xc8, 0x44, 0x01,
 0x08, 0x04, 0x35, 0xc8, 0x22, 0x01, 0x02, 0xc9, 0x24, 0x01, 0x09, 0x06,
 0x33, 0xc8, 0x24, 0x01, 0x02, 0xc9, 0x17, 0x01, 0x02, 0xc9, 0x0d, 0x01,
 0x0a, 0x06, 0x31, 0xc8, 0x26, 0x01, 0x02, 0xc9, 0x18, 0x01, 0x02, 0xc9,
 0x0e, 0x01, 0x0b, 0x06, 0x30, 0xc8, 0x27, 0x01, 0x02, 0xc9, 0x18, 0x01,
 0x03, 0xc9, 0x0e, 0x01, 0x0c, 0x08, 0x2e, 0xc8, 0x0a, 0x01, 0x09, 0xc9,
 0x16, 0x01, 0x02, 0xc9, 0x18, 0x01, 0x04, 0xc9, 0x0f, 0x01, 0x0d, 0x08,
 0x2d, 0xc8, 0x0d, 0x01, 0x09, 0xc9, 0x13, 0x01, 0x04, 0xc9, 0x17, 0x01,
 0x05, 0xc9, 0x0f, 0x01, 0x0e, 0x08, 0x2b, 0xc8, 0x11, 0x01, 0x08, 0xc9,
 0x12, 0x01, 0x04, 0xc9, 0x17, 0x01, 0x05, 0xc9, 0x11, 0x01, 0x0f, 0x08,
 0x2a, 0xc8, 0x13, 0x01, 0x08, 0xc9, 0x11, 0x01, 0x04, 0xc9, 0x17, 0x01,
 0x06, 0xc9, 0x11, 0x01, 0x10, 0x08, 0x28, 0xc8, 0x16, 0x01, 0x08, 0xc9,
 0x10, 0x01, 0x04, 0xc9, 0x17, 0x01, 0x06, 0xc9, 0x13, 0x01, 0x11, 0x08,
 0x27, 0xc8, 0x18, 0x01, 0x08, 0xc9, 0x0f, 0x01, 0x05, 0xc9, 0x16, 0x01,
 0x06, 0xc9, 0x14, 0x01, 0x12, 0x08, 0x26, 0xc8, 0x19, 0x01, 0x08, 0xc9,
 0x0e, 0x01, 0x06, 0xc9, 0x15, 0x01, 0x07, 0xc9, 0x15, 0x01, 0x13, 0x08,
 0x25, 0xc8, 0x1b, 0x01, 0x08, 0xc9, 0x0d, 0x01, 0x06, 0xc9, 0x15, 0x01,
 0x07, 0xc9, 0x16, 0x01, 0x14, 0x08, 0x23, 0xc8, 0x1d, 0x01, 0x08, 0xc9,
 0x0d, 0x01, 0x06, 0xc9, 0x14, 0x01, 0x08, 0xc9, 0x18, 0x01, 0x15, 0x08,
 0x22, 0xc8, 0x1e, 0x01, 0x08, 0xc9, 0x0d, 0x01, 0x07, 0xc9, 0x12, 0x01,
 0x09, 0xc9, 0x19, 0x01, 0x16, 0x08, 0x21, 0xc8, 0x1f, 0x01, 0x08, 0xc9,
 0x0d, 0x01, 0x07, 0xc9, 0x11, 0x01, 0x09, 0xc9, 0x1b, 0x01, 0x17, 0x08,
 0x20, 0xc8, 0x20, 0x01, 0x09, 0xc9, 0x0c, 0x01, 0x07, 0xc9, 0x0f, 0x01,
 0x0b, 0xc9, 0x1c, 0x01, 0x18, 0x08, 0x1f, 0xc8, 0x21, 0x01, 0x09, 0xc9,
 0x0b, 0x01, 0x08, 0xc9, 0x0e, 0x01, 0x0c, 0xc9, 0x1d, 0x01, 0x19, 0x08,
 0x1e, 0xc8, 0x22, 0x01, 0x09, 0xc9, 0x0b, 0x01, 0x09, 0xc9, 0x0c, 0x01,
 0x0c, 0xc9, 0x1f, 0x01, 0x1a, 0x08, 0x1d, 0xc8, 0x23, 0x01, 0x09, 0xc9,
 0x0b, 0x01, 0x09, 0xc9, 0x0a, 0x01, 0x0e, 0xc9, 0x20, 0x01, 0x1b, 0x0a,
 0x1d, 0xc8, 0x23, 0x01, 0x09, 0xc9, 0x0b, 0x01, 0x09, 0xc9, 0x09, 0x01,
 0x0e, 0xc9, 0x15, 0x01, 0x01, 0xc9, 0x0b, 0x01, 0x1c, 0x0a, 0x1c, 0xc8,
 0x23, 0x01, 0x0b, 0xc9, 0x0a, 0x01, 0x09, 0xc9, 0x08, 0x01, 0x0e, 0xc9,
 0x15, 0x01, 0x02, 0xc9, 0x0c, 0x01, 0x1d, 0x0c, 0x1b, 0xc8, 0x0c, 0x01,
 0x02, 0xc9, 0x16, 0x01, 0x0b, 0xc9, 0x0a, 0x01, 0x0a, 0xc9, 0x07, 0x01,
 0x0e, 0xc9, 0x14, 0x01, 0x03, 0xc9, 0x0d, 0x01, 0x1e, 0x0c, 0x1a, 0xc8,
 0x0d, 0x01, 0x03, 0xc9, 0x15, 0x01, 0x0b, 0xc9, 0x09, 0x01, 0x0b, 0xc9,
 0x06, 0x01, 0x0e, 0xc9, 0x13, 0x01, 0x04, 0xc9, 0x0f, 0x01, 0x1f, 0x0c,
 0x19, 0xc8, 0x0f, 0x01, 0x04, 0xc9, 0x13, 0x01, 0x0c, 0xc9, 0x08, 0x01,
 0x0b, 0xc9, 0x05, 0x01, 0x0e, 0xc9, 0x13, 0x01, 0x05, 0xc9, 0x10, 0x01,
 0x20, 0x0c, 0x19, 0xc8, 0x10, 0x01, 0x04, 0xc9, 0x12, 0x01, 0x0c, 0xc9,
 0x08, 0x01, 0x0b, 0xc9, 0x05, 0x01, 0x0e, 0xc9, 0x12, 0x01, 0x05, 0xc9,
 0x11, 0x01, 0x21, 0x0c, 0x18, 0xc8, 0x11, 0x01, 0x06, 0xc9, 0x10, 0x01,
 0x0c, 0xc9, 0x08, 0x01, 0x0c, 0xc9, 0x04, 0x01, 0x0d, 0xc9, 0x11, 0x01,
 0x06, 0xc9, 0x13, 0x01, 0x22, 0x0c, 0x17, 0xc8, 0x13, 0x01, 0x06, 0xc9,
 0x0f, 0x01, 0x0d, 0xc9, 0x07, 0x01, 0x0c, 0xc9, 0x03, 0x01, 0x0e, 0xc9,
 0x0f, 0x01, 0x08, 0xc9, 0x14, 0x01, 0x23, 0x0c, 0x16, 0xc8, 0x14, 0x01,
 0x08, 0xc9, 0x0d, 0x01, 0x0e, 0xc9, 0x06, 0x01, 0x0c, 0xc9, 0x03, 0x01,
 0x0d, 0xc9, 0x0f, 0x01, 0x08, 0xc9, 0x16, 0x01, 0x24, 0x0c, 0x16, 0xc8,
 0x15, 0x01, 0x08, 0xc9, 0x0c, 0x01, 0x0e, 0xc9, 0x06, 0x01, 0x0c, 0xc9,
 0x03, 0x01, 0x0d, 0xc9, 0x0e, 0x01, 0x09, 0xc9, 0x16, 0x01, 0x25, 0x0c,
 0x15, 0xc8, 0x17, 0x01, 0x09, 0xc9, 0x0b, 0x01, 0x0e, 0xc9, 0x04, 0x01,
 0x0d, 0xc9, 0x03, 0x01, 0x0d, 0xc9, 0x0d, 0x01, 0x09, 0xc9, 0x18, 0x01,
 0x26, 0x0c, 0x14, 0xc8, 0x18, 0x01, 0x0a, 0xc9, 0x0a, 0x01, 0x0f, 0xc9,
 0x03, 0x01, 0x0e, 0xc9, 0x02, 0x01, 0x0d, 0xc9, 0x0b, 0x01, 0x0a, 0xc9,
 0x1a, 0x01, 0x27, 0x0c, 0x14, 0xc8, 0x19, 0x01, 0x0a, 0xc9, 0x09, 0x01,
 0x10, 0xc9, 0x02, 0x01, 0x0e, 0xc9, 0x01, 0x01, 0x0d, 0xc9, 0x0b, 0x01,
 0x0b, 0xc9, 0x1a, 0x01, 0x28, 0x0a, 0x13, 0xc8, 0x1b, 0x01, 0x0b, 0xc9,
 0x07, 0x01, 0x11, 0xc9, 0x01, 0x01, 0x1c, 0xc9, 0x09, 0x01, 0x0c, 0xc9,
 0x1c, 0x01, 0x29, 0x08, 0x13, 0xc8, 0x1b, 0x01, 0x0d, 0xc9, 0x06, 0x01,
 0x2d, 0xc9, 0x08, 0x01, 0x0d, 0xc9, 0x1c, 0x01, 0x2a, 0x08, 0x12, 0xc8,
 0x1d, 0x01, 0x0d, 0xc9, 0x05, 0x01, 0x2d, 0xc9, 0x06, 0x01, 0x0e, 0xc9,
 0x1e, 0x01, 0x2b, 0x08, 0x12, 0xc8, 0x1e, 0x01, 0x0e, 0xc9, 0x04, 0x01,
 0x2c, 0xc9, 0x05, 0x01, 0x0f, 0xc9, 0x1e, 0x01, 0x2c, 0x08, 0x11, 0xc8,
 0x1f, 0x01, 0x0f, 0xc9, 0x04, 0x01, 0x2b, 0xc9, 0x03, 0x01, 0x10, 0xc9,
 0x20, 0x01, 0x2d, 0x08, 0x11, 0xc8, 0x20, 0x01, 0x10, 0xc9, 0x02, 0x01,
 0x2b, 0xc9, 0x02, 0x01, 0x10, 0xc9, 0x21, 0x01, 0x2e, 0x06, 0x10, 0xc8,
 0x22, 0x01, 0x10, 0xc9, 0x01, 0x01, 0x3d, 0xc9, 0x22, 0x01, 0x2f, 0x06,
 0x10, 0xc8, 0x22, 0x01, 0x4d, 0xc9, 0x1a, 0x01, 0x01, 0xc9, 0x08, 0x01,
 0x30, 0x08, 0x0f, 0xc8, 0x0c, 0x01, 0x06, 0xc9, 0x12, 0x01, 0x4b, 0xc9,
 0x1a, 0x01, 0x02, 0xc9, 0x09, 0x01, 0x31, 0x08, 0x0f, 0xc8, 0x0a, 0x01,
 0x0a, 0xc9, 0x10, 0x01, 0x4b, 0xc9, 0x1a, 0x01, 0x02, 0xc9, 0x09, 0x01,
 0x32, 0x08, 0x0e, 0xc8, 0x0a, 0x01, 0x0d, 0xc9, 0x0f, 0x01, 0x49, 0xc9,
 0x1a, 0x01, 0x04, 0xc9, 0x09, 0x01, 0x33, 0x08, 0x0e, 0xc8, 0x09, 0x01,
 0x0f, 0xc9, 0x0f, 0x01, 0x48, 0xc9, 0x19, 0x01, 0x05, 0xc9, 0x09, 0x01,
 0x34, 0x08, 0x0e, 0xc8, 0x08, 0x01, 0x12, 0xc9, 0x0d, 0x01, 0x47, 0xc9,
 0x19, 0x01, 0x06, 0xc9, 0x09, 0x01, 0x35, 0x0a, 0x0d, 0xc8, 0x08, 0x01,
 0x14, 0xc9, 0x0d, 0x01, 0x45, 0xc9, 0x07, 0x01, 0x09, 0xc9, 0x08, 0x01,
 0x07, 0xc9, 0x0b, 0x01, 0x36, 0x0a, 0x0d, 0xc8, 0x08, 0x01, 0x04, 0xc9,
 0x02, 0x01, 0x0f, 0xc9, 0x0d, 0x01, 0x44, 0xc9, 0x04, 0x01, 0x1b, 0xc9,
 0x0b, 0x01, 0x37, 0x0a, 0x0d, 0xc8, 0x07, 0x01, 0x02, 0xc9, 0x08, 0x01,
 0x0e, 0xc9, 0x0c, 0x01, 0x42, 0xc9, 0x03, 0x01, 0x1d, 0xc9, 0x0b, 0x01,
 0x38, 0x08, 0x0c, 0xc8, 0x13, 0x01, 0x0f, 0xc9, 0x0a, 0x01, 0x42, 0xc9,
 0x02, 0x01, 0x1e, 0xc9, 0x0c, 0x01, 0x39, 0x06, 0x0c, 0xc8, 0x14, 0x01,
 0x10, 0xc9, 0x09, 0x01, 0x60, 0xc9, 0x0d, 0x01, 0x3a, 0x04, 0x0c, 0xc8,
 0x15, 0x01, 0x77, 0xc9, 0x0e, 0x01, 0x3b, 0x04, 0x0b, 0xc8, 0x17, 0x01,
 0x75, 0xc9, 0x10, 0x01, 0x3c, 0x04, 0x0b, 0xc8, 0x17, 0x01, 0x74, 0xc9,
 0x11, 0x01, 0x3d, 0x04, 0x0b, 0xc8, 0x18, 0x01, 0x71, 0xc9, 0x13, 0x01,
 0x3e, 0x04, 0x0b, 0xc8, 0x19, 0x01, 0x6d, 0xc9, 0x16, 0x01, 0x3f, 0x04,
 0x0b, 0xc8, 0x19, 0x01, 0x69, 0xc9, 0x1a, 0x01, 0x40, 0x04, 0x0a, 0xc8,
 0x1b, 0x01, 0x65, 0xc9, 0x1e, 0x01, 0x41, 0x04, 0x0a, 0xc8, 0x1c, 0x01,
 0x61, 0xc9, 0x21, 0x01, 0x42, 0x04, 0x0a, 0xc8, 0x1d, 0x01, 0x5e, 0xc9,
 0x23, 0x01, 0x43, 0x04, 0x0a, 0xc8, 0x1e, 0x01, 0x5c, 0xc9, 0x24, 0x01,
 0x44, 0x04, 0x0a, 0xc8, 0x20, 0x01, 0x58, 0xc9, 0x26, 0x01, 0x45, 0x04,
 0x09, 0xc8, 0x23, 0x01, 0x55, 0xc9, 0x28, 0x01, 0x46, 0x04, 0x09, 0xc8,
 0x25, 0x01, 0x52, 0xc9, 0x29, 0x01, 0x47, 0x04, 0x09, 0xc8, 0x28, 0x01,
 0x4e, 0xc9, 0x2a, 0x01, 0x48, 0x04, 0x09, 0xc8, 0x2a, 0x01, 0x4d, 0xc9,
 0x29, 0x01, 0x49, 0x04, 0x09, 0xc8, 0x26, 0x01, 0x57, 0xc9, 0x23, 0x01,
 0x4a, 0x04, 0x09, 0xc8, 0x23, 0x01, 0x5f, 0xc9, 0x1e, 0x01, 0x4b, 0x04,
 0x09, 0xc8, 0x1f, 0x01, 0x68, 0xc9, 0x19, 0x01, 0x4c, 0x04, 0x09, 0xc8,
 0x1a, 0x01, 0x71, 0xc9, 0x15, 0x01, 0x4d, 0x04, 0x09, 0xc8, 0x15, 0x01,
 0x7b, 0xc9, 0x10, 0x01, 0x4e, 0x04, 0x09, 0xc8, 0x13, 0x01, 0x81, 0xc9,
 0x0c, 0x01, 0x4f, 0x04, 0x09, 0xc8, 0x0d, 0x01, 0x8a, 0xc9, 0x09, 0x01,
 0x50, 0x04, 0x09, 0xc8, 0x09, 0x01, 0x8c, 0xc9, 0x0b, 0x01, 0x51, 0x04,
 0x09, 0xc8, 0x09, 0x01, 0x88, 0xc9, 0x0f, 0x01, 0x52, 0x04, 0x09, 0xc8,
 0x0d, 0x01, 0x7f, 0xc9, 0x14, 0x01, 0x53, 0x04, 0x09, 0xc8, 0x12, 0x01,
 0x76, 0xc9, 0x18, 0x01, 0x54, 0x04, 0x09, 0xc8, 0x16, 0x01, 0x6d, 0xc9,
 0x1d, 0x01, 0x55, 0x04, 0x09, 0xc8, 0x1c, 0x01, 0x64, 0xc9, 0x20, 0x01,
 0x56, 0x04, 0x09, 0xc8, 0x21, 0x01, 0x5a, 0xc9, 0x25, 0x01, 0x57, 0x04,
 0x09, 0xc8, 0x26, 0x01, 0x51, 0xc9, 0x29, 0x01, 0x58, 0x04, 0x09, 0xc8,
 0x2a, 0x01, 0x4d, 0xc9, 0x29, 0x01, 0x59, 0x04, 0x09, 0xc8, 0x2a, 0x01,
 0x50, 0xc9, 0x26, 0x01, 0x5a, 0x04, 0x09, 0xc8, 0x29, 0x01, 0x54, 0xc9,
 0x23, 0x01, 0x5b, 0x04, 0x0a, 0xc8, 0x27, 0x01, 0x57, 0xc9, 0x20, 0x01,
 0x5c, 0x04, 0x0a, 0xc8, 0x25, 0x01, 0x5a, 0xc9, 0x1f, 0x01, 0x5d, 0x04,
 0x0a, 0xc8, 0x24, 0x01, 0x5d, 0xc9, 0x1d, 0x01, 0x5e, 0x04, 0x0a, 0xc8,
 0x22, 0x01, 0x60, 0xc9, 0x1c, 0x01, 0x5f, 0x04, 0x0a, 0xc8, 0x21, 0x01,
 0x62, 0xc9, 0x1b, 0x01, 0x60, 0x04, 0x0b, 0xc8, 0x1e, 0x01, 0x65, 0xc9,
 0x19, 0x01, 0x61, 0x04, 0x0b, 0xc8, 0x16, 0x01, 0x6d, 0xc9, 0x19, 0x01,
 0x62, 0x04, 0x0b, 0xc8, 0x13, 0x01, 0x71, 0xc9, 0x18, 0x01, 0x63, 0x04,
 0x0b, 0xc8, 0x12, 0x01, 0x73, 0xc9, 0x17, 0x01, 0x64, 0x04, 0x0b, 0xc8,
 0x11, 0x01, 0x75, 0xc9, 0x16, 0x01, 0x65, 0x04, 0x0c, 0xc8, 0x0f, 0x01,
 0x76, 0xc9, 0x15, 0x01, 0x66, 0x06, 0x0c, 0xc8, 0x0e, 0x01, 0x62, 0xc9,
 0x04, 0x01, 0x12, 0xc9, 0x14, 0x01, 0x67, 0x08, 0x0c, 0xc8, 0x0d, 0x01,
 0x1e, 0xc9, 0x02, 0x01, 0x41, 0xc9, 0x09, 0x01, 0x10, 0xc9, 0x13, 0x01,
 0x68, 0x0a, 0x0d, 0xc8, 0x0c, 0x01, 0x1d, 0xc9, 0x03, 0x01, 0x42, 0xc9,
 0x0b, 0x01, 0x0f, 0xc9, 0x07, 0x01, 0x02, 0xc9, 0x07, 0x01, 0x69, 0x0a,
 0x0d, 0xc8, 0x0b, 0x01, 0x1c, 0xc9, 0x04, 0x01, 0x43, 0xc9, 0x0d, 0x01,
 0x0e, 0xc9, 0x04, 0x01, 0x04, 0xc9, 0x07, 0x01, 0x6a, 0x08, 0x0d, 0xc8,
 0x0b, 0x01, 0x1a, 0xc9, 0x06, 0x01, 0x44, 0xc9, 0x0d, 0x01, 0x14, 0xc9,
 0x08, 0x01, 0x6b, 0x08, 0x0e, 0xc8, 0x0a, 0x01, 0x06, 0xc9, 0x19, 0x01,
 0x46, 0xc9, 0x0e, 0x01, 0x11, 0xc9, 0x08, 0x01, 0x6c, 0x08, 0x0e, 0xc8,
 0x0a, 0x01, 0x04, 0xc9, 0x1a, 0x01, 0x47, 0xc9, 0x0f, 0x01, 0x0f, 0xc9,
 0x09, 0x01, 0x6d, 0x08, 0x0e, 0xc8, 0x0a, 0x01, 0x04, 0xc9, 0x1a, 0x01,
 0x48, 0xc9, 0x10, 0x01, 0x0c, 0xc9, 0x0a, 0x01, 0x6e, 0x08, 0x0f, 0xc8,
 0x09, 0x01, 0x03, 0xc9, 0x1a, 0x01, 0x4a, 0xc9, 0x0f, 0x01, 0x0b, 0xc9,
 0x0a, 0x01, 0x6f, 0x08, 0x0f, 0xc8, 0x09, 0x01, 0x03, 0xc9, 0x19, 0x01,
 0x4b, 0xc9, 0x11, 0x01, 0x07, 0xc9, 0x0c, 0x01, 0x70, 0x06, 0x10, 0xc8,
 0x08, 0x01, 0x02, 0xc9, 0x19, 0x01, 0x4d, 0xc9, 0x22, 0x01, 0x71, 0x06,
 0x10, 0xc8, 0x09, 0x01, 0x01, 0xc9, 0x19, 0x01, 0x4e, 0xc9, 0x21, 0x01,
 0x72, 0x08, 0x11, 0xc8, 0x21, 0x01, 0x11, 0xc9, 0x02, 0x01, 0x2a, 0xc9,
 0x02, 0x01, 0x10, 0xc9, 0x20, 0x01, 0x73, 0x08, 0x11, 0xc8, 0x21, 0x01,
 0x10, 0xc9, 0x03, 0x01, 0x2b, 0xc9, 0x03, 0x01, 0x0f, 0xc9, 0x1f, 0x01,
 0x74, 0x08, 0x12, 0xc8, 0x1f, 0x01, 0x0f, 0xc9, 0x05, 0x01, 0x2b, 0xc9,
 0x04, 0x01, 0x0f, 0xc9, 0x1d, 0x01, 0x75, 0x08, 0x12, 0xc8, 0x1f, 0x01,
 0x0e, 0xc9, 0x06, 0x01, 0x2c, 0xc9, 0x05, 0x01, 0x0d, 0xc9, 0x1d, 0x01,
 0x76, 0x08, 0x13, 0xc8, 0x1d, 0x01, 0x0d, 0xc9, 0x08, 0x01, 0x2d, 0xc9,
 0x05, 0x01, 0x0d, 0xc9, 0x1b, 0x01, 0x77, 0x08, 0x13, 0xc8, 0x1c, 0x01,
 0x0d, 0xc9, 0x09, 0x01, 0x2d, 0xc9, 0x07, 0x01, 0x0c, 0xc9, 0x1a, 0x01,
 0x78, 0x0c, 0x14, 0xc8, 0x1b, 0x01, 0x0c, 0xc9, 0x0a, 0x01, 0x0d, 0xc9,
 0x01, 0x01, 0x0e, 0xc9, 0x02, 0x01, 0x0f, 0xc9, 0x08, 0x01, 0x0b, 0xc9,
 0x19, 0x01, 0x79, 0x0c, 0x14, 0xc8, 0x1a, 0x01, 0x0b, 0xc9, 0x0b, 0x01,
 0x0d, 0xc9, 0x02, 0x01, 0x0e, 0xc9, 0x03, 0x01, 0x0f, 0xc9, 0x09, 0x01,
 0x0a, 0xc9, 0x18, 0x01, 0x7a, 0x0c, 0x15, 0xc8, 0x19, 0x01, 0x09, 0xc9,
 0x0d, 0x01, 0x0d, 0xc9, 0x03, 0x01, 0x0d, 0xc9, 0x04, 0x01, 0x0e, 0xc9,
 0x0b, 0x01, 0x09, 0xc9, 0x16, 0x01, 0x7b, 0x0c, 0x16, 0xc8, 0x17, 0x01,
 0x09, 0xc9, 0x0e, 0x01, 0x0d, 0xc9, 0x03, 0x01, 0x0d, 0xc9, 0x04, 0x01,
 0x0e, 0xc9, 0x0c, 0x01, 0x08, 0xc9, 0x15, 0x01, 0x7c, 0x0c, 0x16, 0xc8,
 0x17, 0x01, 0x08, 0xc9, 0x0e, 0x01, 0x0e, 0xc9, 0x03, 0x01, 0x0d, 0xc9,
 0x05, 0x01, 0x0d, 0xc9, 0x0d, 0x01, 0x08, 0xc9, 0x14, 0x01, 0x7d, 0x0c,
 0x17, 0xc8, 0x15, 0x01, 0x07, 0xc9, 0x10, 0x01, 0x0d, 0xc9, 0x04, 0x01,
 0x0c, 0xc9, 0x07, 0x01, 0x0c, 0xc9, 0x0f, 0x01, 0x07, 0xc9, 0x12, 0x01,
 0x7e, 0x0c, 0x18, 0xc8, 0x13, 0x01, 0x07, 0xc9, 0x10, 0x01, 0x0e, 0xc9,
 0x04, 0x01, 0x0c, 0xc9, 0x07, 0x01, 0x0c, 0xc9, 0x11, 0x01, 0x05, 0xc9,
 0x11, 0x01, 0x7f, 0x0c, 0x19, 0xc8, 0x12, 0x01, 0x06, 0xc9, 0x11, 0x01,
 0x0e, 0xc9, 0x04, 0x01, 0x0c, 0xc9, 0x08, 0x01, 0x0b, 0xc9, 0x12, 0x01,
 0x05, 0xc9, 0x0f, 0x01, 0x80, 0x0c, 0x19, 0xc8, 0x11, 0x01, 0x05, 0xc9,
 0x12, 0x01, 0x0e, 0xc9, 0x06, 0x01, 0x0b, 0xc9, 0x08, 0x01, 0x0b, 0xc9,
 0x14, 0x01, 0x04, 0xc9, 0x0e, 0x01, 0x81, 0x0c, 0x1a, 0xc8, 0x10, 0x01,
 0x04, 0xc9, 0x12, 0x01, 0x0f, 0xc9, 0x06, 0x01, 0x0b, 0xc9, 0x09, 0x01,
 0x0a, 0xc9, 0x16, 0x01, 0x02, 0xc9, 0x0d, 0x01, 0x82, 0x0c, 0x1b, 0xc8,
 0x0e, 0x01, 0x03, 0xc9, 0x14, 0x01, 0x0e, 0xc9, 0x07, 0x01, 0x0b, 0xc9,
 0x09, 0x01, 0x0a, 0xc9, 0x17, 0x01, 0x02, 0xc9, 0x0b, 0x01, 0x83, 0x0a,
 0x1c, 0xc8, 0x0d, 0x01, 0x02, 0xc9, 0x14, 0x01, 0x0e, 0xc9, 0x08, 0x01,
 0x0a, 0xc9, 0x0a, 0x01, 0x0a, 0xc9, 0x23, 0x01, 0x84, 0x08, 0x1d, 0xc8,
 0x21, 0x01, 0x0e, 0xc9, 0x0a, 0x01, 0x09, 0xc9, 0x0a, 0x01, 0x0a, 0xc9,
 0x22, 0x01, 0x85, 0x08, 0x1d, 0xc8, 0x21, 0x01, 0x0d, 0xc9, 0x0b, 0x01,
 0x09, 0xc9, 0x0b, 0x01, 0x09, 0xc9, 0x22, 0x01, 0x86, 0x08, 0x1e, 0xc8,
 0x1f, 0x01, 0x0d, 0xc9, 0x0c, 0x01, 0x09, 0xc9, 0x0b, 0x01, 0x09, 0xc9,
 0x21, 0x01, 0x87, 0x08, 0x1f, 0xc8, 0x1e, 0x01, 0x0c, 0xc9, 0x0d, 0x01,
 0x09, 0xc9, 0x0b, 0x01, 0x09, 0xc9, 0x20, 0x01, 0x88, 0x08, 0x20, 0xc8,
 0x1c, 0x01, 0x0b, 0xc9, 0x10, 0x01, 0x07, 0xc9, 0x0c, 0x01, 0x09, 0xc9,
 0x1f, 0x01, 0x89, 0x08, 0x21, 0xc8, 0x1b, 0x01, 0x0a, 0xc9, 0x11, 0x01,
 0x07, 0xc9, 0x0c, 0x01, 0x09, 0xc9, 0x1e, 0x01, 0x8a, 0x08, 0x22, 0xc8,
 0x1a, 0x01, 0x09, 0xc9, 0x12, 0x01, 0x07, 0xc9, 0x0c, 0x01, 0x09, 0xc9,
 0x1d, 0x01, 0x8b, 0x08, 0x23, 0xc8, 0x19, 0x01, 0x08, 0xc9, 0x13, 0x01,
 0x07, 0xc9, 0x0c, 0x01, 0x09, 0xc9, 0x1c, 0x01, 0x8c, 0x08, 0x25, 0xc8,
 0x17, 0x01, 0x07, 0xc9, 0x14, 0x01, 0x07, 0xc9, 0x0d, 0x01, 0x08, 0xc9,
 0x1a, 0x01, 0x8d, 0x08, 0x26, 0xc8, 0x16, 0x01, 0x07, 0xc9, 0x14, 0x01,
 0x07, 0xc9, 0x0d, 0x01, 0x09, 0xc9, 0x18, 0x01, 0x8e, 0x08, 0x27, 0xc8,
 0x15, 0x01, 0x06, 0xc9, 0x16, 0x01, 0x05, 0xc9, 0x0e, 0x01, 0x09, 0xc9,
 0x17, 0x01, 0x8f, 0x08, 0x28, 0xc8, 0x14, 0x01, 0x06, 0xc9, 0x16, 0x01,
 0x05, 0xc9, 0x0f, 0x01, 0x08, 0xc9, 0x16, 0x01, 0x90, 0x08, 0x2a, 0xc8,
 0x13, 0x01, 0x05, 0xc9, 0x16, 0x01, 0x05, 0xc9, 0x10, 0x01, 0x08, 0xc9,
 0x13, 0x01, 0x91, 0x08, 0x2b, 0xc8, 0x12, 0x01, 0x04, 0xc9, 0x17, 0x01,
 0x05, 0xc9, 0x11, 0x01, 0x09, 0xc9, 0x10, 0x01, 0x92, 0x08, 0x2d, 0xc8,
 0x11, 0x01, 0x04, 0xc9, 0x17, 0x01, 0x04, 0xc9, 0x12, 0x01, 0x0b, 0xc9,
 0x0b, 0x01, 0x93, 0x08, 0x2e, 0xc8, 0x10, 0x01, 0x04, 0xc9, 0x17, 0x01,
 0x03, 0xc9, 0x15, 0x01, 0x09, 0xc9, 0x0a, 0x01, 0x94, 0x08, 0x30, 0xc8,
 0x0f, 0x01, 0x03, 0xc9, 0x17, 0x01, 0x03, 0xc9, 0x17, 0x01, 0x04, 0xc9,
 0x0b, 0x01, 0x95, 0x06, 0x31, 0xc8, 0x0f, 0x01, 0x03, 0xc9, 0x16, 0x01,
 0x03, 0xc9, 0x25, 0x01, 0x96, 0x06, 0x33, 0xc8, 0x0f, 0x01, 0x01, 0xc9,
 0x16, 0x01, 0x03, 0xc9, 0x23, 0x01, 0x97, 0x04, 0x35, 0xc8, 0x25, 0x01,
 0x02, 0xc9, 0x21, 0x01, 0x98, 0x04, 0x37, 0xc8, 0x23, 0x01, 0x01, 0xc9,
 0x20, 0x01, 0x99, 0x02, 0x3a, 0xc8, 0x3e, 0x01, 0x9a, 0x02, 0x3c, 0xc8,
 0x3a, 0x01, 0x9b, 0x02, 0x3f, 0xc8, 0x34, 0x01, 0x9c, 0x02, 0x42, 0xc8,
 0x2e, 0x01, 0x9d, 0x02, 0x46, 0xc8, 0x26, 0x01, 0x9e, 0x02, 0x4b, 0xc8,
 0x1c, 0x01, 0x9f, 0x02, 0x53, 0xc8, 0x0c, 0x01, 0xab, 0x01, 0x98, 0xc8,
 0xac, 0x01, 0x98, 0xc8, 0xad, 0x01, 0x98, 0xc8, 0xae, 0x09, 0x1c, 0xc8,
 0x06, 0x00, 0x02, 0xc8, 0x01, 0x00, 0x0b, 0xc8, 0x01, 0x00, 0x0f, 0xc8,
 0x07, 0x00, 0x51, 0xc8, 0xaf, 0x0d, 0x1a, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x04, 0x00, 0x0b, 0xc8, 0x02, 0x00, 0x0c, 0xc8, 0x03, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x0e, 0xc8, 0x02, 0x00, 0x3f, 0xc8, 0xb0, 0x0d, 0x1a, 0xc8,
 0x01, 0x00, 0x08, 0xc8, 0x02, 0x00, 0x0a, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x02, 0x00, 0x09, 0xc8, 0x02, 0x00, 0x0d, 0xc8, 0x02, 0x00, 0x3f, 0xc8,
 0xb1, 0x0b, 0x19, 0xc8, 0x02, 0x00, 0x08, 0xc8, 0x02, 0x00, 0x0a, 0xc8,
 0x04, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x4d, 0xc8,
 0xb2, 0x0b, 0x19, 0xc8, 0x02, 0x00, 0x09, 0xc8, 0x01, 0x00, 0x09, 0xc8,
 0x05, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x4d, 0xc8,
 0xb3, 0x0d, 0x19, 0xc8, 0x03, 0x00, 0x08, 0xc8, 0x01, 0x00, 0x09, 0xc8,
 0x01, 0x00, 0x02, 0xc8, 0x03, 0x00, 0x07, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x03, 0x00, 0x4c, 0xc8, 0xb4, 0x1b, 0x19, 0xc8, 0x04, 0x00, 0x10, 0xc8,
 0x02, 0x00, 0x02, 0xc8, 0x03, 0x00, 0x07, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x03, 0x00, 0x09, 0xc8, 0x04, 0x00, 0x03, 0xc8, 0x04, 0x00, 0x03, 0xc8,
 0x03, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x08, 0xc8, 0x05, 0x00, 0x07, 0xc8,
 0x05, 0x00, 0x02, 0xc8, 0x03, 0x00, 0x03, 0xc8, 0x05, 0x00, 0x04, 0xc8,
 0xb5, 0x21, 0x1a, 0xc8, 0x06, 0x00, 0x0d, 0xc8, 0x01, 0x00, 0x03, 0xc8,
 0x03, 0x00, 0x07, 0xc8, 0x03, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x01, 0xc8, 0x06, 0x00, 0x02, 0xc8,
 0x06, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x03, 0xc8, 0x03, 0x00, 0x01, 0xc8, 0x02, 0x00, 0x01, 0xc8,
 0x03, 0x00, 0x03, 0xc8, 0x03, 0x00, 0x02, 0xc8, 0xb6, 0x1f, 0x1b, 0xc8,
 0x08, 0x00, 0x09, 0xc8, 0x02, 0x00, 0x04, 0xc8, 0x03, 0x00, 0x06, 0xc8,
 0x03, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x0b, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x04, 0x00, 0x04, 0xc8, 0x03, 0x00, 0x04, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x02, 0xc8,
 0xb7, 0x1f, 0x1d, 0xc8, 0x08, 0x00, 0x07, 0xc8, 0x01, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x06, 0xc8, 0x03, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x03, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x03, 0xc8, 0x03, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x01, 0xc8, 0xb8, 0x1d, 0x20, 0xc8, 0x06, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x03, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x03, 0x00, 0x0b, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x0b, 0xc8, 0x02, 0x00, 0x03, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x07, 0xc8,
 0x02, 0x00, 0x01, 0xc8, 0xb9, 0x19, 0x23, 0xc8, 0x03, 0x00, 0x05, 0xc8,
 0x0b, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x08, 0xc8, 0x05, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x03, 0xc8, 0x0b, 0x00, 0x01, 0xc8, 0xba, 0x1f, 0x19, 0xc8,
 0x01, 0x00, 0x0a, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x01, 0x00, 0x08, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x03, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x0b, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x04, 0xc8,
 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x0a, 0xc8,
 0xbb, 0x1d, 0x19, 0xc8, 0x01, 0x00, 0x0a, 0xc8, 0x02, 0x00, 0x04, 0xc8,
 0x02, 0x00, 0x08, 0xc8, 0x03, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x09, 0xc8,
 0x03, 0x00, 0x0c, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x05, 0xc8, 0x05, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x0a, 0xc8,
 0xbc, 0x1d, 0x19, 0xc8, 0x02, 0x00, 0x09, 0xc8, 0x02, 0x00, 0x04, 0xc8,
 0x01, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x09, 0xc8,
 0x03, 0x00, 0x0c, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x09, 0xc8, 0x03, 0x00, 0x09, 0xc8,
 0xbd, 0x1f, 0x19, 0xc8, 0x02, 0x00, 0x08, 0xc8, 0x02, 0x00, 0x04, 0xc8,
 0x01, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x09, 0xc8,
 0x02, 0x00, 0x0d, 0xc8, 0x02, 0x00, 0x05, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x02, 0x00, 0x03, 0xc8, 0x02, 0x00, 0x0b, 0xc8, 0x02, 0x00, 0x06, 0xc8,
 0x01, 0x00, 0x02, 0xc8, 0xbe, 0x1f, 0x19, 0xc8, 0x04, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x01, 0x00, 0x0b, 0xc8, 0x03, 0x00, 0x06, 0xc8,
 0x03, 0x00, 0x05, 0xc8, 0x03, 0x00, 0x0e, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x06, 0xc8, 0x02, 0x00, 0x03, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x05, 0x00, 0x02, 0xc8, 0x06, 0x00, 0x06, 0xc8,
 0x03, 0x00, 0x04, 0xc8, 0x02, 0x00, 0x02, 0xc8, 0xbf, 0x1b, 0x19, 0xc8,
 0x01, 0x00, 0x02, 0xc8, 0x07, 0x00, 0x04, 0xc8, 0x05, 0x00, 0x08, 0xc8,
 0x06, 0x00, 0x06, 0xc8, 0x07, 0x00, 0x0e, 0xc8, 0x06, 0x00, 0x01, 0xc8,
 0x06, 0x00, 0x02, 0xc8, 0x06, 0x00, 0x02, 0xc8, 0x06, 0x00, 0x02, 0xc8,
 0x06, 0x00, 0x02, 0xc8, 0x02, 0x00, 0x04, 0xc8, 0x07, 0x00, 0x06, 0xc8,
 0x06, 0x00, 0x03, 0xc8, 0xc0, 0x05, 0x80, 0xc8, 0x02, 0x00, 0x05, 0xc8,
 0x03, 0x00, 0x0e, 0xc8, 0xc1, 0x05, 0x7f, 0xc8, 0x02, 0x00, 0x07, 0xc8,
 0x02, 0x00, 0x0e, 0xc8, 0xc2, 0x05, 0x7f, 0xc8, 0x02, 0x00, 0x07, 0xc8,
 0x02, 0x00, 0x0e, 0xc8, 0xc3, 0x05, 0x7f, 0xc8, 0x03, 0x00, 0x05, 0xc8,
 0x02, 0x00, 0x0f, 0xc8, 0xc4, 0x03, 0x80, 0xc8, 0x08, 0x00, 0x10, 0xc8 };


/*
 * Subroutine:	load_logo
 * Purpose:	place logo image in image buffer
 */
void load_logo ( shortbuf, bufwd, bufht )
     short *shortbuf;
     int bufwd, bufht;
{
  register short *bufpt, *bufend;
  register short bkgd;
  static void make_logo();

  /* fill buffer with background color */
  bufpt = shortbuf;
  bufend = bufpt + (bufwd * bufht);
  bkgd = BKGD;
  while( bufpt < bufend ) {
    *bufpt = bkgd;
    bufpt++;
  }
  /* center the logo in the buffer (order is important for correct rounding) */
  shortbuf += ((((bufht - LOGO_HEIGHT) / 2) * bufwd) +
	       ((bufwd - LOGO_WIDTH) / 2));
  make_logo(logo, LOGO_SZ, shortbuf, bufwd);
}
