import ranlib
import Numeric
from types import *

ArgumentError = "ArgumentError"

def seed(x=0,y=0):
	if type (x) != IntType or type (y) != IntType :
		raise ArgumentError, "seed requires integer arguments."
	if x == y == 0:
		import time
		t = time.time()
		x = int(t)
		y = int((t-int(t))*1000000)
	ranlib.set_seeds(x,y)
        return

seed()

def get_seed():
	return ranlib.get_seeds()

def random(shape=[]):
	if type(shape) == type(0): shape = [shape]
	n = Numeric.multiply.reduce(shape)
	s = ranlib.sample(n)
	if shape != []:
		return Numeric.reshape(s, shape)
	else:
		return s[0]

def uniform(minimum, maximum, shape=[]):
	return minimum + (maximum-minimum)*random(shape)

def randint(minimum, maximum=None, shape=[]):
	if maximum == None:
		maximum = minimum
		minimum = 0
	a = Numeric.asarray(uniform(minimum, maximum, shape)).astype(Numeric.Int)
	if shape == []: a = a[0]
	return a
	 
def permutation(n):
	return Numeric.argsort(random(n))

def test():
	print get_seed()
	print random()
	print random(100)
	print random([10,10])
	print uniform(0.5,0.6, (10,2))
	print randint(36, shape=[100])
	print permutation(30)

if __name__ == '__main__': test()
