'\"
'\" Copyright 1994-1996 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\"
.so man.macros
.HS watch BLT
.BS
.SH NAME
watch \- call Tcl procedures before and after each command
.SH SYNOPSIS
\fBwatch create\fR \fIwatchName\fR ?\fIoptions\fR?
.sp
\fBwatch activate\fR \fIwatchName\fR
.sp
\fBwatch deactivate\fR \fIwatchName\fR
.sp
\fBwatch delete\fR \fIwatchName\fR
.sp
\fBwatch configure\fR \fIwatchName\fR ?\fIoptions\fR
.sp
\fBwatch info\fR \fIwatchName\fR
.sp
\fBwatch names\fR 
.BE
.SH DESCRIPTION
The \fBwatch\fR command arranges for Tcl procedures to be invoked
before and after the execution of each Tcl command.
.SH INTRODUCTION
When an error occurs in Tcl, the global variable \fIerrorInfo\fR will
contain a stack-trace of the active procedures when the error occured.
Sometimes, however, the stack trace is insufficient.  You may need to
know exactly where in the program's execution the error occured.  In
cases like this, a more general tracing facility would be useful.
.PP
The \fBwatch\fR command lets you designate Tcl procedures to be
invoked before and after the execution of each Tcl command.  This
means you can display the command line and its results for each
command as it executes.  Another use is to profile your Tcl commands.
You can profile any Tcl command (like \fBif\fR and \fBset\fR), not just
Tcl procedures.
.SH EXAMPLE
The following example use \fBwatch\fR to trace Tcl commands 
(printing to standard error) both before and after they are executed. 
.DS 
proc preCmd { level command argv } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $command"
}

proc postCmd { level command argv retcode results } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $argv\n<= ($retcode) $results"
}
watch create trace \\
	-postcmd postCmd -precmd preCmd
.DE
.SH "OPERATIONS"
The following operations are available for the \fBwatch\fR command:
.TP
\fBwatch activate \fIwatchName\fR 
Activates the watch, causing Tcl commands the be traced to the
maximum depth selected.
.TP
\fBwatch create \fIwatchName\fR ?\fIoptions\fR?...
Creates a new watch \fIwatchName\fR. It's an error if another watch 
\fIwatchName\fR already exists and an error message will be returned.
\fIOptions\fR may have any of the values accepted by the 
\fBwatch configure\fR command.
This command returns the empty string.  
.TP
\fBwatch configure \fIwatchName\fR ?\fIoptions...\fR?
Queries or modifies the configuration options of the watch \fIwatchName\fR.
\fIWatchName\fR is the name of a watch.
\fIOptions\fR may have any of the following values:
.RS
.TP
\fB\-active \fIboolean\fR
Specifies if the watch is active.
By default, watches are active when created.
.TP
\fB\-postcmd \fIstring\fR
Specifies a Tcl procedure to be called immediately after each Tcl
command.  \fIString\fR is name of a Tcl procedure and any extra
arguments to be passed to it.  Before \fIstring\fR is invoked, five
more arguments are appended: 1) the current level 2) the current
command line 3) a list containing the command after substitutions and
split into words 4) the return code of the command, and 5) the results
of the command.  The return status of the postcmd procedure is always
ignored.
.TP
\fB\-precmd \fIstring\fR 
Specifies a Tcl procedure to be called immediately before each Tcl
command.  \fIString\fR is name of a Tcl procedure and any extra
arguments to be passed to it.  Before \fIstring\fR is invoked, three
arguments are appended: 1) the current level 2) the current command
line, and 3) a list containing the command after substitutions and
split into words.  The return status of the \fB\-precmd\fR procedure
is always ignored.
.TP
\fB\-maxlevel \fInumber\fR
Specifies the maximum evaluation depth to watch Tcl commands.
The default maximum level is 10000.
.RE
.TP
\fBwatch deactivate \fIwatchName\fR 
Deactivates the watch.  The \fB\-precmd\fR and \fB\-postcmd\fR procedures
will no longer be invoked.
.TP
\fBwatch info \fIwatchName\fR 
Returns the configuration information associated with the 
watch \fIwatchName\fR.  \fIWatchName\fR is the name of a watch.
.TP
\fBwatch names\fR ?\fIstate\fR?
Lists the names of the watches for a given state.  \fIState\fR may be
one of the following: \fCactive\fR, \fCidle\fR, or \fCignore\fR.  If a
\fIstate\fR argument isn't specified,
 all watches are
listed.
.RE
.SH KEYWORDS
debug, profile
