#!/bin/sh
#$Id: makefiles.sh,v 1.5 1998/07/01 12:18:16 hniemann Exp $
# make the .files file for Makefile:
# automatically create the necessary targets to
# 
# make txt   - process all sgml files to txt (in the ../txt directory)
#
# make html  - process all sgml files to html (in the ../html/$i directory)
#
#
echo "making .files"
# all sgml files in the directory into a single line (!)
SGMLFILES=""
for i in `ls -m *.sgml | sed -e 's/,//g'` ; do
	SGMLFILES="$SGMLFILES $i"
done
# all except the index:
SGMLFILESI=`echo $SGMLFILES | sed -e 's/index.sgml//g'`
echo "FILES=$SGMLFILES" > .files
# main targets
echo -e "default: txt html\n" >> .files
echo -e "all: default tex dvi ps cipdist\n" >> .files
echo -e "clean: txt-clean html-clean tex-clean dvi-clean ps-clean\n" >> .files
# (don't make dvi and tex by default)
#
# txt target
echo -n "txt: " >> .files
for i in $SGMLFILES ; do
	echo -n "../`basename $i .sgml`.txt " >>.files
done
echo -en "\n\n" >> .files  # finish line + empty line 
echo -e "txt-clean: \n\tcd .. ; rm -f $SGMLFILES \n" | sed -e "s/.sgml/.txt/g" >> .files
for i in $SGMLFILES ; do
	j=`basename $i .sgml`
#	echo -e "$j.txt: ../$j.txt\n" >>.files
	echo -e "../$j.txt: $i" >>.files
	echo -e "\t(cd .. ; sgml2txt -f sgml/$i)\n" >> .files
done
#   HTML targets
echo -n "html: " >> .files
for i in $SGMLFILESI ; do
	echo -n "../html/`basename $i .sgml`/`basename $i .sgml`.html " >>.files
done
echo -n "../html/index.html" >> .files
echo -en "\n\n" >> .files  # finish line + empty line 
#echo -e "html: $SGMLFILES \n" | sed -e "s/.sgml/.html/g" >> .files
echo -e "html-clean: \n\tcd ../html ; rm -rf $SGMLFILESI ; rm -f index.html\n" | sed -e "s/.sgml//g" >> .files
for i in $SGMLFILESI ; do
	j=`basename $i .sgml`
#	echo -e "$j.html: ../html/$j/$j.html\n" >>.files
	echo -e "../html/$j/$j.html: $i" >>.files
	echo -e "\t(mkdir -p ../html/$j ; cd ../html/$j ; sgml2html ../../sgml/$i)\n" >> .files
done
# specialcase Index to go to ggi/doc/html:
#echo -e "index.html: ../html/index.html\n" >>.files
echo -e "../html/index.html: index.sgml" >>.files
echo -e "\t(cd ../html ; sgml2html ../sgml/index.sgml)\n" >> .files
#
# postscript target
echo -n "ps: " >> .files
for i in $SGMLFILES ; do
	echo -n "../ps/`basename $i .sgml`.ps " >>.files
done
echo -en "\n\n" >> .files  # finish line + empty line 
#echo -e "ps: $SGMLFILES \n" | sed -e "s/.sgml/.ps/g" >> .files
echo -e "ps-clean: \n\tcd ../ps ; rm -f $SGMLFILES \n" | sed -e "s/.sgml/.ps/g" >> .files
for i in $SGMLFILES ; do
	j=`basename $i .sgml`
#	echo -e "$j.ps: ../ps/$j.ps\n\t @echo -e \"\"\n" >>.files
	echo -e "../ps/$j.ps: $i" >>.files
	echo -e "\t(cd ../ps ; sgml2latex -o ps ../sgml/$i)\n" >> .files
done
#
# dvi target
echo -n "dvi: " >> .files
for i in $SGMLFILES ; do
	echo -n "../dvi/`basename $i .sgml`.dvi " >>.files
done
echo -en "\n\n" >> .files  # finish line + empty line 
#echo -e "dvi: $SGMLFILES \n" | sed -e "s/.sgml/.dvi/g" >> .files
echo -e "dvi-clean: \n\tcd ..\dvi ; rm -f $SGMLFILES \n" | sed -e "s/.sgml/.dvi/g" >> .files
for i in $SGMLFILES ; do
	j=`basename $i .sgml`
#	echo -e "$j.dvi: ../dvi/$j.dvi\n\t @echo -e \"\"\n" >>.files
	echo -e "../dvi/$j.dvi: $i" >>.files
	echo -e "\t(cd ../dvi ; sgml2latex -o dvi ../sgml/$i)\n" >> .files
done
#
# tex target
echo -n "tex: " >> .files
for i in $SGMLFILES ; do
	echo -n "../tex/`basename $i .sgml`.tex " >>.files
done
echo -en "\n\n" >> .files  # finish line + empty line 
#echo -e "tex: $SGMLFILES \n" | sed -e "s/.sgml/.tex/g" >> .files
echo -e "tex-clean: \n\tcd ../tex ; rm -f $SGMLFILES \n" | sed -e "s/.sgml/.tex/g" >> .files
for i in $SGMLFILES ; do
	j=`basename $i .sgml`
#	echo -e "$j.tex: ../tex/$j.tex\n" >>.files
	echo -e "../tex/$j.tex: $i" >>.files
	echo -e "\t(cd ../tex ; sgml2latex -o tex ../sgml/$i)\n" >> .files
done

# index generation
echo -e "index: index.sgml\n" >> .files
echo -e "index.sgml: $SGMLFILESI\n\tsh makeindex.sh\n" >> .files
#
#
#
#  automatic creation of tarballs for distribution
#
# main target pack
echo -n "pack: " >> .files
for j in sgml txt tex dvi ps html ; do 
    echo -n "../tar/ggidoc.$j.tar.gz ">>.files
done
#for i in $SGMLFILES ; do
#	j=`basename $i .sgml`
#	echo -n "../tar/$j.tar.gz ">>.files
#done
#echo -e "\n\t(cd ../tar ; ln -f ../txt/*.txt . ; tar cvf ggidoc.all.tar *.tar.gz *.txt)" >> .files
echo -e "\n\n">>.files
#
# tar files of *.sgml and such
echo -e "../tar/ggidoc.sgml.tar.gz: index.sgml\n\t(cd ../.. ; tar cvzf doc/tar/ggidoc.sgml.tar.gz doc/sgml/*.sgml)" >> .files

echo -e "../tar/ggidoc.txt.tar.gz: $j\n\t(cd ../.. ; tar cvzf doc/tar/ggidoc.txt.tar.gz doc/*.txt)" >> .files
for j in tex dvi ps ; do 
    echo -e "../tar/ggidoc.$j.tar.gz: $j\n\t(cd ../.. ; tar cvzf doc/tar/ggidoc.$j.tar.gz doc/$j/*.$j)" >> .files
done

echo -e "../tar/ggidoc.html.tar.gz: html\n\t(cd ../.. ; tar cvzf doc/tar/ggidoc.html.tar.gz doc/html/index.html doc/html/*/*html)" >> .files
echo -e "../tar/ggidoc.html.cip.tar.gz: html\n\t(cd ../html ; tar cvzf ../tar/ggidoc.html.cip.tar.gz index.html */*html)" >> .files
#
echo -e "cipdist: ../tar/ggidoc.html.cip.tar.gz pack\n"\
"\tif [ -r cipdist.sh ] ; then sh cipdist.sh ; else echo cipdist.sh does not exist ; fi" >> .files

#
# individual tarballs for each doc: necessary??
# hard to make, because copying everything into one place seems necessary
# postponed.
#for i in $SGMLFILES ; do
#    j=`basename $i .sgml`
#    echo -n "../tar/$j.tar.gz: ">>.file
#    for k in txt tex dvi ps ; do 
#	echo -n "../$k/$j.$k ">>.files
#    done;
#    echo - .......
