/* $Id: copybox.c,v 1.6 1998/09/20 21:22:16 marcus Exp $
***************************************************************************

  Graphics library for GGI. Pixels.

  Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <sys/ioctl.h>

#ifdef _AIX
#include <sys/types.h>
#include <unistd.h>
#endif

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>
#include <kgi/errno.h>

/**********/
/* BitBlt */
/**********/

int GGIcopybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	int RC;
	int result;

	CHECKXYWH(vis,x,y,w,h);
	CHECKXYWH(vis,nx,ny,w,h);
	
	if ((RC=ioctl(vis->fd,(int)GRAPHICS_COPYBOX,&x))<0) 
	{ 
		result = (RC == -1) ? errno : -RC;
		if ((result&NOSUP_MASK)==NOSUP)
		{	switch(result&AVE_MASK)
			{ case AVE_NOW:
				return fallback_opdraw.copybox(vis,x,y,w,h,nx,ny);
			  default:
				return (vis->opdraw->copybox=fallback_opdraw.copybox)(vis,x,y,w,h,nx,ny);
			}
		}
	}
	return RC;
}
