/* $Id: color.c,v 1.7 1998/10/09 19:13:20 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin4lib.h"

/* The magic numbers are calculated like so:
 *   2^14+2^12+..2^4+2^2+1
 *
 *  Where the differece between the powers is equal to
 * the number of bits of color. Pretty spiff stuff...
 */
# define MAGIC_1	0xffff
# define MAGIC_2	0x5555

/*********************************************
 * Let's pretend we have a 1:2:1 color cube! *
 *********************************************/

/* Return `1:2:1' mapping
 */
ggi_pixel GGI_lin4_mapcolor(ggi_visual *vis,ggi_color *col)
{
	return	((col->r>>(GGI_COLOR_PRECISION-1))<<3)|
		((col->g>>(GGI_COLOR_PRECISION-2))<<1)|
		(col->b>>(GGI_COLOR_PRECISION-1));
}

/* Map `1:2:1' pixel to color
 */
int GGI_lin4_unmappixel(ggi_visual *vis,ggi_pixel pixel,ggi_color *col)
{
	if (pixel>255 || col==NULL) 
		return -1;

	col->b=(pixel & 0x1) * MAGIC_1; 
	col->g=((pixel>>1)&0x3) * MAGIC_2;
	col->r=((pixel>>3)&0x1) * MAGIC_1;

	return 0;	
}

/* Pack the colors into an array
 */
int GGI_lin4_packcolors(ggi_visual *vis,void *outbuf,ggi_color *cols,int len)
{
	uint8 *obuf=(uint8 *)outbuf;
	int i;

	for (i=0;i<len/2;i++) 
		*(obuf++)=(uint8)(ggiMapColor(vis,(cols++)) << 4)
			| (uint8)(ggiMapColor(vis,(cols++)));
	
	if (len & 1) {
		*obuf = ggiMapColor(vis, cols) << 4;
	}
	
	return 0;
}
	
/* Unpack into the ggi_color array the values of the pixels
 */
int GGI_lin4_unpackpixels(ggi_visual *vis,void *outbuf,ggi_color *cols,int len)
{
	uint8 *obuf=(uint8 *)outbuf;
	int i;
	ggi_pixel tmp;
	
	for (i=0;i<len/2;i++) {
		tmp = *obuf >> 4;
		ggiUnmapPixel(vis,tmp,cols++);
		tmp = *(obuf++) & 0x0F;
		ggiUnmapPixel(vis,tmp,cols++);
	}
	
	if (len & 1) {
		tmp = *obuf >> 4;
		ggiUnmapPixel(vis,tmp,cols++);
	}

	return 0;
}	
	
  
