/* $Id: pixel.c,v 1.9 1998/09/26 03:20:45 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin4lib.h"

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGI_lin4_drawpixel(ggi_visual *vis,int x,int y)
{
	uint8 pel;
/*	uint8 clr;*/
	uint8 *fb;
	uint8 xs;
	
	CHECKXY(vis,x,y);
 	
	/* Read-modify-write. */
	
	fb = (uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x>>1);
	pel = *fb;

	/* This does:
	 
	 * if (x & 1)
	 *    clr = (pel & 0xF0) | (LIBGGI_GC_FGCOLOR(vis) & 0x0f);
	 * else clr = (pel & 0x0F) | ((LIBGGI_GC_FGCOLOR(vis) & 0x0f) << 4);
	 */
	xs = (x & 1) << 2;
	*fb = (pel & (0x0F << xs)) | ((LIBGGI_GC_FGCOLOR(vis) & 0x0f) << (xs ^ 4));

	return 0;
}

int GGI_lin4_drawpixel_nc(ggi_visual *vis,int x,int y)
{
	uint8 pel;
/*	uint8 clr;*/
	uint8 *fb;
	uint8 xs;
	
	/* Read-modify-write. */
	
	fb = (uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x>>1);
	pel = *fb;

	/* This does:
	 
	 * if (x & 1)
	 *    clr = (pel & 0xF0) | (LIBGGI_GC_FGCOLOR(vis) & 0x0f);
	 * else clr = (pel & 0x0F) | ((LIBGGI_GC_FGCOLOR(vis) & 0x0f) << 4);
	 */
	xs = (x & 1) << 2;
	*fb = (pel & (0x0F << xs)) | ((LIBGGI_GC_FGCOLOR(vis) & 0x0f) << (xs ^ 4));

	return 0;
}

int GGI_lin4_putpixel_nc(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	uint8 pel;
	uint8 *fb;
	uint8 xs;
	
	fb = (uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x>>1);
	pel = *fb;

	xs = (x & 1) << 2;
	
	*fb=(pel & (0x0F << xs)) | ((col & 0x0f) << (xs ^ 4));

	return 0;
}

int GGI_lin4_putpixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	uint8 pel;
	uint8 *fb;
	uint8 xs;
	
	CHECKXY(vis,x,y);
 	
	fb = (uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x>>1);
	pel = *fb;

	xs = (x & 1) << 2;
	
	*fb=(pel & (0x0F << xs)) | ((col & 0x0f) << (xs ^ 4));

	return 0;
}

int GGI_lin4_getpixel(ggi_visual *vis,int x,int y,ggi_pixel *pixel)
{ 
	int pel;
	uint8 xs;
	
	pel = *(uint8 *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+(x>>1);

	xs = (x & 1) << 2;
	*pixel = (ggi_pixel)((pel & (0x0f << xs)) >> (xs ^ 4)); 

	return 0;
}

