/* $Id: gtext.c,v 1.7 1998/09/26 03:20:50 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1998 MenTaLguY  [mentalg@geocities.com]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin8lib.h"

#include <ggi/internal/font/8x8>

int GGI_lin8_putc(ggi_visual *vis, int x, int y, char c)
{
#define char_width 8
#define char_height 8
	int offset, x_run, y_run;
	uint8 *bitmap;

	bitmap = font + ( c * char_height );
	x_run = char_width;
	y_run = char_height;
	offset = 0;

	{
		int delta;

		delta = LIBGGI_GC(vis)->cliptl.x - x;
		if ( delta > 0 ) {
			if ( delta >= x_run ) {
				return 0;
			} else {
				x_run -= delta;
				offset += delta;
				x += delta;
			}
		}
		delta = ( x + x_run ) - LIBGGI_GC(vis)->clipbr.x;
		if ( delta > 0 ) {
			if ( delta >= x_run ) {
				return 0;
			} else {
				x_run -= delta;
			}
		}
		delta = LIBGGI_GC(vis)->cliptl.y - y;
		if ( delta > 0 ) {
			if ( delta >= y_run ) {
				return 0;
			} else {
				y_run -= delta;
				bitmap += delta;
				y += delta;
			}
		}
		delta = ( y + y_run ) - LIBGGI_GC(vis)->clipbr.y;
		if ( delta > 0 ) {
			if ( delta >= y_run ) {
				return 0;
			} else {
				y_run -= delta;
			}
		}
	}

	{
		int y_iter;
		register uint8 *fb;
		int add_stride;

		add_stride = LIBGGI_FB_W_STRIDE(vis);
		fb = (uint8 *)LIBGGI_CURWRITE(vis) + ( y * add_stride ) + x;
		add_stride -= x_run;
		y_run += y; x_run += x;

		for ( y_iter = y ; y_iter < y_run ; y_iter++, bitmap++,
		      fb += add_stride )
		{
			register int x_iter;
			register uint8 row;

			row = *bitmap << offset;

			for ( x_iter = x ; x_iter < x_run ; x_iter++,
			      row <<= 1, fb++ )
			{
				*fb = ( row & 128 )
				      ? (uint8)LIBGGI_GC_FGCOLOR(vis)
				      : (uint8)LIBGGI_GC_BGCOLOR(vis);
			}
		}
	}

	return 0;
#undef char_width
#undef char_height
}
