/* $Id: pixel.c,v 1.6 1998/09/26 03:21:04 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixel Stubs.

   Copyright (C) 1998 Andrew Apted  [andrew.apted@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

/****************/
/* draw a pixel */
/****************/

int GGI_stubs_drawpixel_nc(ggi_visual *vis, int x, int y)
{
	return _ggiPutPixelNC(vis, x, y, LIBGGI_GC_FGCOLOR(vis));
}

int GGI_stubs_drawpixel(ggi_visual *vis, int x, int y)
{
	return ggiPutPixel(vis, x, y, LIBGGI_GC_FGCOLOR(vis));
}

int GGI_stubs_putpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{
	CHECKXY(vis, x, y);

	return _ggiPutPixelNC(vis, x, y, col);
}
