/* $Id: visual.c,v 1.15 1998/10/18 15:52:34 becka Exp $
***************************************************************************

   Generic drawing library

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "stublib.h"

int GGIdlinit(ggi_visual *vis, const char *version,void *argptr)
{
	/* Generic drawing
	 */
	vis->opdraw->putc=GGI_stubs_putc;
	vis->opdraw->puts=GGI_stubs_puts;
	vis->opdraw->getcharsize=GGI_stubs_getcharsize;

	vis->opdraw->putpixel=GGI_stubs_putpixel;
	vis->opdraw->drawpixel=GGI_stubs_drawpixel;
	vis->opdraw->drawpixel_nc=GGI_stubs_drawpixel_nc;
	vis->opdraw->drawhline=GGI_stubs_drawhline;
	vis->opdraw->drawhline_nc=GGI_stubs_drawhline_nc;
	vis->opdraw->drawvline=GGI_stubs_drawvline;
	vis->opdraw->drawvline_nc=GGI_stubs_drawvline_nc;
	vis->opdraw->drawbox=GGI_stubs_drawbox;
	vis->opdraw->drawline=GGI_stubs_drawline;
	
	if (! (GT_SUBSCHEME(LIBGGI_GT(vis)) & GT_SUB_PACKED_GETPUT))

	switch ((GT_SIZE(LIBGGI_GT(vis)) + 7) / 8) {

		case 1: vis->opdraw->puthline=_GGI_stubs_L1_puthline;
			vis->opdraw->putvline=_GGI_stubs_L1_putvline;
			vis->opdraw->gethline=_GGI_stubs_L1_gethline;
			vis->opdraw->getvline=_GGI_stubs_L1_getvline;
			break;

		case 2: vis->opdraw->puthline=_GGI_stubs_L2_puthline;
			vis->opdraw->putvline=_GGI_stubs_L2_putvline;
			vis->opdraw->gethline=_GGI_stubs_L2_gethline;
			vis->opdraw->getvline=_GGI_stubs_L2_getvline;
			break;

		case 3: vis->opdraw->puthline=_GGI_stubs_L3_puthline;
			vis->opdraw->putvline=_GGI_stubs_L3_putvline;
			vis->opdraw->gethline=_GGI_stubs_L3_gethline;
			vis->opdraw->getvline=_GGI_stubs_L3_getvline;
			break;

		case 4: vis->opdraw->puthline=_GGI_stubs_L4_puthline;
			vis->opdraw->putvline=_GGI_stubs_L4_putvline;
			vis->opdraw->gethline=_GGI_stubs_L4_gethline;
			vis->opdraw->getvline=_GGI_stubs_L4_getvline;
			break;
	}

	vis->opdraw->putbox=GGI_stubs_putbox;
	vis->opdraw->getbox=GGI_stubs_getbox;

	vis->opdraw->copybox=GGI_stubs_copybox;
	vis->opdraw->crossblit=GGI_stubs_crossblit;
	vis->opdraw->fillscreen=GGI_stubs_fillscreen;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
