/* $Id: visual.c,v 1.15 1998/10/18 15:52:35 becka Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Color handling
	 */
	visual->opcolor->mapcolor=GGImapcolor;
	visual->opcolor->unmappixel=GGIunmappixel;

	/* Frame handling
	 */

	visual->opdraw->setreadframe=GGI_default_setreadframe;
	visual->opdraw->setwriteframe=GGI_default_setwriteframe;
	
	/* Generic drawing is minimal
	 */
	visual->opdraw->drawpixel_nc=GGIdrawpixel_nc;
	visual->opdraw->drawpixel=GGIdrawpixel;
	visual->opdraw->putpixel_nc=GGIputpixel_nc;
	visual->opdraw->putpixel=GGIputpixel;
	visual->opdraw->getpixel=GGIgetpixel;
	visual->opdraw->putc=GGIputc;
	visual->opdraw->getcharsize=GGIgetcharsize;
	
	return GGI_DL_OPDRAW|GGI_DL_OPCOLOR;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
