/* $Id: gtext.c,v 1.9 1998/09/20 21:23:31 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 MenTaLguY        [mentalg@geocities.com]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#define PIXEL_ADDR(vis, x, y)  \
	((uint32 *) LIBGGI_CURWRITE(vis) + y*LIBGGI_FB_W_STRIDE(vis)/sizeof(uint32) + x)

int GGIgetcharsize(ggi_visual *vis, int *width, int *height)
{
	/* In text mode, the charsize is just 1x1 pixels */

	*width = *height = 1;
	return 0;
}

int GGIputc(ggi_visual *vis, int x, int y, char c)
{
	CHECKXY(vis, x, y);

	*PIXEL_ADDR(vis, x, y) = 
		((LIBGGI_GC_BGCOLOR(vis) & ATTR_FGCOLOR) >> 8) |
		 (LIBGGI_GC_FGCOLOR(vis) & ATTR_FGCOLOR) | 
		 (((int) c & 0xff) << 24);

	return 0;
}
