/*
 * saver.c - (c) 1998 Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/time.h>
#ifdef __linux__
#include <linux/vt.h>
#endif
#include <string.h>
#include <ggi/ggi.h>

int timeout=1;

ggi_visual_t visual;

ggi_color map[256];

#define STARANZ 100

#define ggiMonPower(x)

int xsize,ysize;

int getic(void)
{ FILE *hand;
  int num,cnt;
  int c2=0;
  if ((hand=fopen("/proc/interrupts","r"))==NULL) 
    { perror("open /proc/interrupts"); 
      ggiPanic("Do you have /proc mounted ?\n"); }
  while(!feof(hand))
  { fscanf(hand,"%d:%d%*[^\n]",&num,&cnt);
    switch(num) /* Add other interrupts as you want it ... */
    { case 1: /* Keyboard */
      case 3: /* Mice on Com2/Com1 */
      case 4: c2+=cnt;break;
    }
  }
  fclose(hand);
  return(c2);
}

volatile int switchaway,switchto;

#if 0
void MyEvHand(struct ggi_event ev)
{ if (ev.evdata.vt.subtype==VT_SWITCH_AWAY) switchaway++;
  if (ev.evdata.vt.subtype==VT_SWITCH_TO) switchto++; }
#endif

/* These are the graphics effects displayed when active */

double rand01(void)
{ return (rand()&0xffff)/(double)0x10000; }

void ge_stars(void)
{ 
  int x1,y,z;

  typedef struct { double x,y,z; } pix3d;
  typedef struct { int x1,y; } pix2d;
  pix3d pix[STARANZ],*pp;
  pix2d oldpos[STARANZ];
  double da,nda,dz,ndz,cx,sx,cz,sz,z0,hlp;

  z0=2.0*ysize;
  memset(pix,0,sizeof(pix));
  for(z=0;z<STARANZ;z++) pix[z].z=-z0+50;
  memset(oldpos,0,sizeof(oldpos));

  y=0;da=nda=0.0;dz=ndz=0.0;
  while(!switchaway&&!ggiKbhit(visual))
  { if (rand01()<0.001) nda=(rand01()-0.5)/200.0;
    da=(nda+999.0*da)/1000.0;
    cx=cos(da);sx=sin(da);
    if (rand01()<0.001) ndz=(rand01()-0.5)/200.0;
    dz=(ndz-10*nda+989.0*dz)/1000.0;
    cz=cos(dz/10);sz=sin(dz/10);
    for(z=0;z<STARANZ;z++)
    { 
      ggiSetGCForeground(visual,0);
      ggiDrawPixel(visual,oldpos[z].x1,oldpos[z].y);

      pp=&pix[z];
      retry:
      pp->z-=5.0;
      hlp  =pp->x* cx+pp->y*sx;
      pp->y=pp->x*-sx+pp->y*cx;
      pp->x=hlp;
      hlp  =pp->x* cz+pp->z*sz;
      pp->z=pp->x*-sz+pp->z*cz;
      pp->x=hlp;
      hlp=z0/(pp->z+z0);
      x1=xsize/2+pp->x*hlp;
      y=ysize/2+pp->y*hlp;
      
      if (pp->z<-z0+100.0 || x1<10 || x1>=xsize-10 
                          || y <10 || y >=ysize-10 ) 
      { pp->x=rand01()*z0*2-1*z0;pp->y=rand01()*2*z0-1*z0;
        pp->z=rand01()*z0*10+z0;goto retry;
      }
      ggiSetGCForeground(visual,128);
      ggiDrawPixel(visual,oldpos[z].x1=x1,oldpos[z].y=y);
    }
/*   usleep(1);*/
  }
}

void ge_stars3d(void)
{ 
  int x1,x2,y,z;

  typedef struct { double x,y,z; } pix3d;
  typedef struct { int x1,x2,y; } pix2d;
  pix3d pix[STARANZ],*pp;
  pix2d oldpos[STARANZ];
  double da,nda,dz,ndz,cx,sx,cz,sz,z0,hlp;

  z0=2.0*ysize;
  memset(pix,0,sizeof(pix));
  for(z=0;z<STARANZ;z++) pix[z].z=-z0+50;
  memset(oldpos,0,sizeof(oldpos));

  y=0;da=nda=0.0;dz=ndz=0.0;
  while(!switchaway&&!ggiKbhit(visual))
  { if (rand01()<0.001) nda=(rand01()-0.5)/500.0;
    da=(nda+999.0*da)/1000.0;
    cx=cos(da);sx=sin(da);
    if (rand01()<0.001) ndz=(rand01()-0.5)/500.0;
    dz=(ndz-10*nda+989.0*dz)/1000.0;
    cz=cos(dz/10);sz=sin(dz/10);
    for(z=0;z<STARANZ;z++)
    { 
      ggiSetGCForeground(visual,0);
      ggiDrawPixel(visual,oldpos[z].x1,oldpos[z].y);
      ggiDrawPixel(visual,oldpos[z].x2,oldpos[z].y);

      pp=&pix[z];
      retry:
      pp->z-=5.0;
      hlp  =pp->x* cx+pp->y*sx;
      pp->y=pp->x*-sx+pp->y*cx;
      pp->x=hlp;
      hlp  =pp->x* cz+pp->z*sz;
      pp->z=pp->x*-sz+pp->z*cz;
      pp->x=hlp;
      hlp=z0/(pp->z+z0);
      x1=xsize/2+(pp->x-xsize/8)*hlp;
      x2=x1+xsize/4*hlp;
      y=ysize/2+pp->y*hlp;
      
      if (pp->z<-z0+100.0 || x1<10 || x1>=xsize-10 
      			  || x2<10 || x2>=xsize-10
                          || y <10 || y >=ysize-10 ) 
      { pp->x=rand01()*z0*2-1*z0;pp->y=rand01()*2*z0-1*z0;
        pp->z=rand01()*z0*10+z0;goto retry;
      }
      ggiSetGCForeground(visual,128);
      ggiDrawPixel(visual,oldpos[z].x1=x1,oldpos[z].y=y);
      ggiSetGCForeground(visual,1);
      ggiDrawPixel(visual,oldpos[z].x2=x2,y);
    }
/*   usleep(1);*/
  }
}

void ge_bounce(void)
{ int c,lx,ly;
  double x,y,dx,dy;
  int xx[256],yy[256];

  srand(time(NULL));
  lx=x=xsize/2;ly=y=10;
  for(c=0;c<256;c++) xx[c]=yy[c]=5;
  ggiSetGCForeground(visual,c=0);
  ggiFillscreen(visual);
  while(!switchaway&&!ggiKbhit(visual))
  { dx=(rand()%0x1ff)/255.0-1;
    dy=(rand()%0x3ff)/511.0-0.3;
    while(!switchaway&&!ggiKbhit(visual))
    { x+=dx;y+=dy;
      if (x<10||x>xsize-11) {dx=-dx;x+=dx;}
      if (y<10||y>ysize-11) {dy=-dy;y+=dy;}
      if (y<ysize-20) dy+=0.001;
      dx*=.9999;dy*=.9999;
      if (fabs(dx)<1e-2) break;
      if (lx==(int)x&&ly==(int)y) continue;
      c++;c&=0xff;if (!c) c++;
      ggiSetGCForeground(visual,0);
      ggiDrawBox(visual,xx[c]-5,yy[c]-5,xx[c]+5,yy[c]+5);
      lx=xx[c]=x;ly=yy[c]=y;
      ggiSetGCForeground(visual,c);
      ggiDrawBox(visual,xx[c]-5,yy[c]-5,xx[c]+5,yy[c]+5);
/*      if (!(c&33)) usleep(1);*/
    }
  }
}

void ge_crazy(void)
{ int x,y;

  for(x=-(ysize-1);;)
  { if (switchaway||ggiKbhit(visual)) break;

    y=x;if (y<0) y=-y;

    ggiSetGCForeground(visual,1);
    ggiDrawHLine(visual,0,y,xsize/2);

    ggiSetGCForeground(visual,128);
    ggiDrawHLine(visual,xsize/2,ysize-1-y,xsize/2);

    if ((x&15)==0) usleep(1);
    ggiSetGCForeground(visual,0);
    ggiDrawHLine(visual,0,y,xsize/2);
    ggiDrawHLine(visual,xsize/2,ysize-1-y,xsize/2);

    if (++x>ysize-1) x=-(ysize-1);
  }
}


void ge_pong(void)
{ int x,y,dx,dy,h;

  x=30;y=20;dx=1;dy=1;
  while(1)
  { if (switchaway||ggiKbhit(visual)) break;

    if (!(x&3)) usleep(1);
    if (x==xsize-6||x==5) dx=-dx;
    if (y==ysize-6||y==5) dy=-dy;
    ggiSetGCForeground(visual,0);
    h=y;if (h<10) h=10;if (h>=ysize-10) h=ysize-11;
    ggiDrawBox(visual,0,h-10,5,20);
    ggiDrawBox(visual,xsize-6,h-10,5,20);
#if 0
    ggiDrawCircle(visual,x,y,3);
    ggiDrawCircle(visual,x,y,2);
    ggiDrawCircle(visual,x,y,1);
#endif
    x+=dx;y+=dy;
    ggiSetGCForeground(visual,64);
#if 0
    ggiDrawCircle(visual,x,y,3);
    ggiDrawCircle(visual,x,y,2);
    ggiDrawCircle(visual,x,y,1);
#endif
    ggiSetGCForeground(visual,1);
    h=y;if (h<10) h=10;if (h>=ysize-10) h=ysize-11;
    ggiDrawBox(visual,0,h-10,5,20);
    ggiSetGCForeground(visual,128);
    ggiDrawBox(visual,xsize-6,h-10,5,20);

  }
}

void ge_vesa_blank(void)
{ ggiMonPower(PWR_STANDBY);
  while(!switchaway&&!ggiKbhit(visual));
  ggiMonPower(PWR_ON); }

void ge_vesa_blank2(void)
{ ggiMonPower(PWR_SUSPEND);
  while(!switchaway&&!ggiKbhit(visual));
  ggiMonPower(PWR_ON); }

void ge_vesa_blank3(void)
{ ggiMonPower(PWR_OFF);
  while(!switchaway&&!ggiKbhit(visual));
  ggiMonPower(PWR_ON); }

struct scrsaver { void (*func)(void);
		  char *name; } SaverList[]=
		{ { ge_bounce,     "Jumping blob" },
		  { ge_stars,      "Starfield"},
		  { ge_stars3d,    "Starfield Stereo"},
		  { ge_crazy,      "Crazy Lines"},
		  { ge_pong,   	   "Ping Pong"},
		  { ge_vesa_blank, "Power Standby"},
		  { ge_vesa_blank2,"Power Suspend"},
		  { ge_vesa_blank3,"Power Off"},
		  { NULL       ,  NULL}		/* Terminator */
		   };

struct scrsaver *SaverActive=SaverList;

void do_saver(void)
{ /*int oldvt;*/
  switchaway=0;
#if 0
  if ((oldvt=ggi_get_active_vt())<=0) return;
  ggi_vt_activate(0);
  ggiSetGCForeground(visual,0);ggiFillscreen(visual);
  SaverActive->func();
  while(ggiKbhit(visual)) ggiGetc(visual);
  if (!switchaway) ggi_vt_activate(oldvt);
#else
  SaverActive->func();
#endif
}

void blank_screen2(int interactive)
{ int c;
  char hlpbuf[128];
  
/*  ggi_register_evh(EV_ALL,MyEvHand);*/

  if ((visual=ggiOpen(NULL))==NULL)
  { fprintf(stderr,"cannot open device.\n");exit(1);
  }

  if (  ggiSetGraphMode(visual,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_8BIT) )
    ggiPanic("Cannot open one of the default modes.");
  { ggi_mode mode;
    ggiGetMode(visual,&mode);
    xsize=mode.visible.x;
    ysize=mode.visible.y;
  }
      
  for(c=1;c<256;c++)
  { map[c].r=63*8*abs(c-128);
    map[c].b=63*7*(128-abs(c-128));
    map[c].g=63*100; }
  map[0].r=map[0].g=map[0].b=0;
  ggiSetPalette(visual,0,256,map);
  ggiFillscreen(visual);

  if (!interactive) { do_saver(); return; }
  else
  { switchaway=0;
    while(!switchaway)
    { for(c=0;c<ysize;c++)
      { ggiSetGCForeground(visual,c/2+1);ggiDrawHLine(visual,0,c,xsize); }
      ggiSetGCForeground(visual,128);
      ggiPuts(visual,10,10, "*** Screen - Saver ***");
      ggiPuts(visual,10,30, "Configuration Screen :");
      sprintf(hlpbuf,"n/p Type: %15s",SaverActive->name);
      ggiPuts(visual,10,50, hlpbuf);
      sprintf(hlpbuf,"+/- Time: %4d minutes",timeout);
      ggiPuts(visual,10,70, hlpbuf);
      ggiPuts(visual,10,100,"Switch away to activate");
      while (!ggiKbhit(visual))
	      ;
      c=ggiGetc(visual);
      switch(c) {
      case '+': if (timeout<1440) timeout++;break;
      case '-': if (timeout>   1) timeout--;break;
      case 'p': if (SaverActive-SaverList>0) SaverActive--;break;
      case 'n': if ((SaverActive+1)->func) SaverActive++;break;
      case 't':  ggiSetGCForeground(visual,0);
	      ggiFillscreen(visual);do_saver();break;
      case '\x1b':
      case 'q':
	      ggiSetGCForeground(visual,0);
	      ggiClose(visual);
	      ggiExit();
	      exit(0);
      default:
	      printf("Sym is %x.\n",c);
	      break;
      }
    }
    ggiClose(visual);
  }
}

int main(int argc,char *argv[])
{
	int ic,ic2,cnt,x;
	
	if (ggiInit() != 0) {
		fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
			argv[0]);
		exit(1);
	}

  ic=cnt=0;
  switchto=1;
  
  if (argc>=2)
  { x=atoi(argv[1]);switchto=0;
    if (x>0&&x<1440 /* 1 Day ... */) timeout=x;
  }

  if (argc>=3)
  { x=atoi(argv[2]);
    if (x>=0&&x<sizeof(SaverList)/sizeof(SaverList[0]))
      SaverActive=SaverList+x;
  }
         
  while(1)
  { 
    if ((ic2=getic())==ic) 
    { if (++cnt>=timeout) 
      { blank_screen2(0);
        switchto=0;cnt=0;
      } 
    }
    else {cnt=0;ic=ic2;}
    
    if (!switchto) sleep(1/*60*/);
    if (switchto) {blank_screen2(1);switchto=0;}
  }

  ggiClose(visual);
  ggiExit();
  return(0);
}
