/* $Id: Xvisual.h,v 1.8 1998/10/13 07:54:13 marcus Exp $
***************************************************************************

   Display-Xlib: data

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

ggifunc_flush		GGI_X_flush;
ggifunc_getmode		GGI_X_getmode;
ggifunc_setmode		GGI_X_setmode;
ggifunc_checkmode	GGI_X_checkmode;
ggifunc_getapi 		GGI_X_getapi;
ggifunc_setflags	GGI_Xlib_setflags;

ggifunc_eventpoll	GGI_X_eventpoll;
ggifunc_eventread	GGI_X_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_setpalvec	GGI_X_setpalvec;

ggifunc_drawpixel	GGI_Xlib_drawpixel;
ggifunc_putpixel	GGI_Xlib_putpixel;
ggifunc_getpixel	GGI_Xlib_getpixel;

ggifunc_drawline	GGI_Xlib_drawline;
ggifunc_drawhline	GGI_Xlib_drawhline;
ggifunc_puthline	GGI_Xlib_puthline;
ggifunc_drawvline	GGI_Xlib_drawvline;
ggifunc_putvline	GGI_Xlib_putvline;
	 
ggifunc_drawbox		GGI_Xlib_drawbox;
ggifunc_putbox		GGI_Xlib_putbox;
ggifunc_copybox		GGI_Xlib_copybox;
ggifunc_getbox		GGI_Xlib_getbox;
ggifunc_fillscreen	GGI_Xlib_fillscreen;

struct Xhooks { 
	Display *display;
	Colormap cmap;
	int cmap_first,cmap_last;
	Window window;
	GC  gc;
	GC  tempgc;          /* Used in putpixel */
	ggi_mutex XLibLock;
	int screen;
	int        nocols;   /* Number of colors in the colormap */
	int viswidth, visheight;
	int  relptr;
	unsigned int relptr_keymask;
	sint32 oldmousex;
	sint32 oldmousey;
	unsigned long red_mask;
	unsigned long green_mask;
	unsigned long blue_mask;
	short red_shift;
	short green_shift;
	short blue_shift;
};

#define XLIB_PRIV(vis) ((struct Xhooks *)LIBGGI_PRIVATE(vis))

#define RELPTR_KEYS { XK_Control_L, XK_Alt_L, 'm' }
#define RELPTR_KEYINUSE (1 | (1<<1) | (1<<2))
#define RELPTR_NUMKEYS  3

#define XLIB_DOSYNC(vis) \
{\
	if (!(LIBGGI_FLAGS(vis) & GGIFLAG_ASYNC))\
		GGI_X_flush(vis, 1);\
}
