/* $Id: mode.c,v 1.14 1998/10/13 07:54:14 marcus Exp $
***************************************************************************

   Graphics library for GGI. Mode management.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

static void GGI_Xlib_gcchanged(ggi_visual *vis, int mask)
{
	if ((mask & GGI_GCCHANGED_CLIP)) {
		XRectangle xrect;
		xrect.x = LIBGGI_GC(vis)->cliptl.x;
		xrect.y = LIBGGI_GC(vis)->cliptl.y;
		xrect.width = LIBGGI_GC(vis)->clipbr.x-LIBGGI_GC(vis)->cliptl.x;
		xrect.height = LIBGGI_GC(vis)->clipbr.y-LIBGGI_GC(vis)->cliptl.y;
		XSetClipRectangles(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
						   0, 0, &xrect, 1, Unsorted);
		XSetClipRectangles(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->tempgc,
						   0, 0, &xrect, 1, Unsorted);
	}
	if ((mask & GGI_GCCHANGED_FG)) {
		XSetForeground(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
					   LIBGGI_GC(vis)->fg_color);
	}
	if ((mask & GGI_GCCHANGED_BG)) {
		XSetBackground(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
					   LIBGGI_GC(vis)->fg_color);
	}
}

int GGI_X_flush(ggi_visual *vis, int tryflag)
{
	struct Xhooks *xhook=(struct Xhooks *)LIBGGI_PRIVATE(vis);
	
	_ggiLock(xhook->XLibLock);

	if (xhook->cmap && xhook->cmap_first<xhook->cmap_last) {
		
		int x;
		XColor xcol;
		for(x=xhook->cmap_first;x<xhook->cmap_last;x++)	{
			xcol.red  =vis->palette[x].r;
			xcol.green=vis->palette[x].g;
			xcol.blue =vis->palette[x].b;
			xcol.pixel=x;
			xcol.flags= DoRed | DoGreen | DoBlue ;
			XStoreColor(xhook->display, xhook->cmap,&xcol);
		}
		xhook->cmap_first=256;
		xhook->cmap_last=0;
		XSetWindowColormap(xhook->display, xhook->window, xhook->cmap);
	}
	
	XFlush(xhook->display);

	_ggiUnlock(xhook->XLibLock);
	
	return 0;
}

/*************************/
/* set the current flags */
/*************************/
int GGI_Xlib_setflags(ggi_visual *vis,ggi_flags flags)
{
	LIBGGI_FLAGS(vis)=flags;
	return 0;
}

#define GGI_XLIB_TARGET
#include "../X_common/mode.inc"
