/* $Id: color.c,v 1.11 1998/09/24 01:23:01 marcus Exp $
***************************************************************************

   Graphics library for GGI.  Palette functions for AA target.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "aavisual.h"

int GGI_aa_setpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap)
{
	int x;
        struct AAhooks *AAhook=LIBGGI_PRIVATE(vis);
                                                                                        	

	DPRINT("AA setpalette.\n");

	if (start == GGI_PALETTE_DONTCARE) start = 0;

	if (colormap==NULL || start+len > (1<<GT_DEPTH(LIBGGI_GT(vis))))
		return -1;

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

       	for(x=start; x<start+len; x++)
	{
		aa_setpalette(AAhook->pal, x, vis->palette[x].r>>8,
       				 vis->palette[x].g>>8, 
       				 vis->palette[x].b>>8 );
	}

	return 0;
}
