/* $Id: visual.c,v 1.26 1998/10/25 12:02:17 marcus Exp $
***************************************************************************

   AAlib target for GGI.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#include "aavisual.h"

void _GGI_aa_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	struct AAhooks *aainfo;

	DPRINT("AA-lib starting.\n");
	
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	LIBGGI_PRIVATE(vis)=aainfo=_ggi_malloc(sizeof(struct AAhooks));
	aainfo->opmansync=_ggi_malloc(sizeof(_ggi_opmansync));

	_ggiLockInit(aainfo->aalock);

	aainfo->context=0;
	aainfo->lx=0;
	aainfo->ly=0;
	aainfo->lb=0;
	aainfo->lastkey=0;
	aainfo->lastkeyticks=0;
	
	/* Get options from environment variable AAOPTS */
	if(!aa_parseoptions(NULL, NULL, NULL, NULL))
		fprintf(stderr, "display-aa: warning: parsing AAOPTS failed\n");


	if(!_ggiAddDL(vis, "helper-mansync", (char*) aainfo->opmansync, NULL, 0)) {
		fprintf(stderr, "display-aa: Cannot load required helper-mansync!\n");
		return GGI_DL_ERROR;
	}

	MANSYNC_init(vis);

	/* Has mode management */
	vis->opdisplay->flush=GGI_aa_flush;
	vis->opdisplay->getmode=GGI_aa_getmode;
	vis->opdisplay->setmode=GGI_aa_setmode;
	vis->opdisplay->checkmode=GGI_aa_checkmode;
	vis->opdisplay->getapi =GGI_aa_getapi;
	vis->opdisplay->setflags=GGI_aa_setflags;

	/* Has Event management */
	vis->opdisplay->eventpoll=GGI_aa_eventpoll;
	vis->opdisplay->eventread=GGI_aa_eventread;
	vis->opdisplay->seteventmask=GGIseteventmask;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct AAhooks *aainfo;

	MANSYNC_deinit(vis);

	_GGI_aa_freedbs(vis);

	/* FIXME !!! */
	if ((aainfo=LIBGGI_PRIVATE(vis)) != NULL)
	{
		if (aainfo->context)
		{
			aa_uninitmouse(aainfo->context);
			aa_uninitkbd(aainfo->context);
			aa_close(aainfo->context);
		}
		free(aainfo->opmansync);		

		_ggiLockDestroy(aainfo->aalock);

		free(LIBGGI_PRIVATE(vis));
	}
	
	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
