/* $Id: gt-auto.inc,v 1.2 1998/09/20 18:19:34 steve Exp $
***************************************************************************

   Common GT_AUTO handling code.

   Copyright (C) 1998  Andrew Apted  <andrew.apted@ggi-project.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

static ggi_graphtype _GGIhandle_gtauto(ggi_graphtype gt)
{
	if (GT_SCHEME(gt) == GT_AUTO) {

		if ((GT_DEPTH(gt)!=GT_AUTO && GT_DEPTH(gt)>=9) ||
		    (GT_SIZE(gt) !=GT_AUTO && GT_SIZE(gt) >=9)) {

			GT_SETSCHEME(gt, GT_TRUECOLOR);
		} else {
			GT_SETSCHEME(gt, GT_PALETTE);
		}
	}

	if (GT_SCHEME(gt) == GT_TEXT) {

		if (GT_DEPTH(gt)==GT_AUTO && GT_SIZE(gt)==GT_AUTO) {
			GT_SETDEPTH(gt, 4);
			GT_SETSIZE(gt, 16);
			
		} else if (GT_DEPTH(gt) == GT_AUTO) {
			GT_SETDEPTH(gt, (GT_SIZE(gt) <= 16) ? 4 : 8);
			
		} else if (GT_SIZE(gt) == GT_AUTO) {
			GT_SETSIZE(gt, (GT_DEPTH(gt) <= 4) ? 16 : 32);
		}

		return gt;
	}

	if (GT_DEPTH(gt)==GT_AUTO && GT_SIZE(gt)==GT_AUTO) {
		GT_SETDEPTH(gt, (GT_SCHEME(gt)==GT_TRUECOLOR) ? 24 : 8);
		
	} else if (GT_DEPTH(gt) == GT_AUTO) {
		GT_SETDEPTH(gt, (GT_SIZE(gt) <= 24) ? GT_SIZE(gt) : 24);
	}

	if (GT_SIZE(gt) == GT_AUTO) {

		if (GT_DEPTH(gt) <= 8) {

			if (GT_DEPTH(gt) == 3) {
				GT_SETSIZE(gt, 4);
				
			} else if (GT_DEPTH(gt) >= 5) {
				GT_SETSIZE(gt, 8);
			} else {
				GT_SETSIZE(gt, GT_DEPTH(gt));
			}
		} else {
			GT_SETSIZE(gt, (GT_DEPTH(gt) + 7) & ~7);
		}
	}

	return gt;
}
