/* $Id: fbdev.h,v 1.18 1998/10/30 05:09:50 ajapted Exp $
***************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _DISPLAY_FBDEV_H
#define _DISPLAY_FBDEV_H

#include <unistd.h>
#include <termios.h>
#include <linux/fb.h>

#include <ggi/internal/ggi-dl.h>


/**************************************************
 **
 **  FbDev private defines
 **
 **************************************************/

#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(n)  (((n) < 0) ? -(n) : (n))
#endif

ggifunc_getmode		GGI_fbdev_getmode;
ggifunc_setmode		GGI_fbdev_setmode;
ggifunc_checkmode	GGI_fbdev_checkmode;
ggifunc_resetmode	GGI_fbdev_resetmode;
ggifunc_getapi		GGI_fbdev_getapi;
ggifunc_flush		GGI_fbdev_flush;
ggifunc_setflags	GGI_fbdev_setflags;
		
ggifunc_setpalvec	GGI_fbdev_setpalvec;
ggifunc_setorigin	GGI_fbdev_setorigin;
ggifunc_setdisplayframe	GGI_fbdev_setdisplayframe;


/* Visual-specific private data */

typedef struct fbdev_hook
{	
	/* Framebuffer info */

	void *fb_ptr;
	long  fb_size;
	long  mmap_size;
	long  frame_size;

	char *devicetype;

	struct fb_var_screeninfo var;
	struct fb_fix_screeninfo fix;

	uint16 reds[256];
	uint16 greens[256];
	uint16 blues[256];
	
	/* Original mode on framebuffer */

	struct fb_var_screeninfo orig_var;
	struct fb_fix_screeninfo orig_fix;
	
	uint16 orig_reds[256];
	uint16 orig_greens[256];
	uint16 orig_blues[256];

	/* Miscellaneous */

	int need_redraw;
	
	/* Kgicon specific */
	
	ggi_gc *normalgc;
	int have_kgi;

} fbdev_hook;

#define FBDEV_PRIV(vis) ((fbdev_hook *)LIBGGI_PRIVATE(vis))


/* Linux_common routines */

extern int  vtswitch_open(ggi_visual *vis);
extern void vtswitch_close(ggi_visual *vis);


/* Internal routines */

extern void _GGI_fbdev_save_palette(ggi_visual *vis);
extern void _GGI_fbdev_save_panning(ggi_visual *vis);

extern void _GGI_fbdev_restore_palette(ggi_visual *vis);
extern void _GGI_fbdev_restore_panning(ggi_visual *vis);


#endif  /* _DISPLAY_FBDEV_H */
