/* $Id: glidevisual.h,v 1.10 1998/10/03 02:03:51 marcus Exp $
***************************************************************************

   LibGGI GLIDE target

   Copyright (C) 1997	Jon Taylor	[taylorj@ecs.csus.edu]
   Copyright (C) 1998	Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <glide.h>
#include <ggi/internal/ggi-dl.h>

ggifunc_flush		GGI_glide_flush;
ggifunc_getmode		GGI_glide_getmode;
ggifunc_setmode		GGI_glide_setmode;
ggifunc_checkmode	GGI_glide_checkmode;
ggifunc_getapi		GGI_glide_getapi;
ggifunc_flush		GGI_glide_flush;	

ggifunc_eventpoll	GGI_glide_eventpoll;
ggifunc_eventread	GGI_glide_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_setreadframe	GGI_glide_setreadframe;
ggifunc_setwriteframe	GGI_glide_setwriteframe;
ggifunc_setdisplayframe	GGI_glide_setdisplayframe;

ggifunc_fillscreen	GGI_glide_fillscreen;

ggifunc_drawpixel	GGI_glide_drawpixel;
ggifunc_putpixel	GGI_glide_putpixel;
ggifunc_getpixel	GGI_glide_getpixel;

ggifunc_drawline	GGI_glide_drawline;
ggifunc_drawhline	GGI_glide_drawhline;
ggifunc_drawvline	GGI_glide_drawvline;
ggifunc_puthline	GGI_glide_puthline;
ggifunc_putvline	GGI_glide_putvline;
ggifunc_gethline	GGI_glide_gethline;
ggifunc_getvline	GGI_glide_getvline;

ggifunc_drawbox		GGI_glide_drawbox;
/*ggifunc_copybox	GGI_glide_copybox;*/
ggifunc_putbox		GGI_glide_putbox;
ggifunc_getbox		GGI_glide_getbox;

ggifunc_putc		GGI_glide16_putc;
ggifunc_putc		GGI_glide32_putc;

#define GLIDE_PRIV(vis) ((struct glide_hooks *)LIBGGI_PRIVATE(vis))

#define VTSWITCH_VT_FD(vis)	(GLIDE_PRIV(vis)->kbd_fd)
#define VTSWITCH_PRIV(vis)	(GLIDE_PRIV(vis)->vt_priv)
#define KEYBOARD_FD(vis)	(GLIDE_PRIV(vis)->kbd_fd)
#define KEYBOARD_PRIV(vis)	(GLIDE_PRIV(vis)->kbd_priv)
#define MOUSE_FD(vis)		(GLIDE_PRIV(vis)->mouse_fd)
#define MOUSE_PRIV(vis)		(GLIDE_PRIV(vis)->mouse_priv)

struct glide_hooks
{
	GrVertex   fgvertex;
	GrVertex   bgvertex;
	GrLfbSrcFmt_t src_format;
	GrBuffer_t readbuf;
	GrBuffer_t writebuf;
	FxI32 bytes_per_pixel;
	int kbd_fd;
	void *kbd_priv;
	void *mouse_priv;
	void *vt_priv;
	int mouse_fd;
	int setmodesuccess;
	char *mousetype;
};

/* Linux_common routines */

extern int  vtswitch_open(ggi_visual *vis);
extern void vtswitch_close(ggi_visual *vis);

extern int  keyboard_init(ggi_visual *vis);
extern void keyboard_exit(ggi_visual *vis);
extern void keyboard_handle_data(ggi_visual *vis);

extern int  mouse_init(ggi_visual *vis, char *typename);
extern void mouse_exit(ggi_visual *vis);
extern void mouse_handle_data(ggi_visual *vis);
