/* $Id: events.c,v 1.6 1998/09/20 21:24:12 marcus Exp $
***************************************************************************

   Display-kgi: event management

   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>

#include <ggi/internal/ggi-dl.h>
#include "../common/evqueue.inc"

/************************** GGI Functions ***************************/
/* Event Handling */
ggi_event_mask GGIeventpoll(ggi_visual_t vis,ggi_event_mask mask,
			    struct timeval *t)
{
#define BUFFER_SIZE (sizeof(ggi_event)*4)
	fd_set fds;
	int err;
	struct timeval *timeout,t_zero={0,0};
	ggi_event_mask evmask;
	unsigned char *bp,buff[BUFFER_SIZE];

DPRINT("GGIeventpoll(%p,0x%.8x",vis,mask);
if (t==NULL) {
	DPRINT(",NULL)\n");
} else {
	DPRINT(",{%d,%d})\n",t->tv_sec,t->tv_usec);
}

	evmask=_ggiEvQueueSeen(vis,mask);
	if (evmask!=0)  
		return evmask;

	if (LIBGGI_SELECT_FD(vis) < 0) 
		return 0;

	timeout = &t_zero;
	do {
		FD_ZERO(&fds);
		FD_SET(LIBGGI_SELECT_FD(vis),&fds);

		/* !!! FIXME  The following EINTR handling code relies
		 * on the fact that Linux modifies the timeout to
		 * indicate the time not slept.
		 */

		err=select(LIBGGI_SELECT_FD(vis)+1,&fds,NULL,NULL,timeout);

		if ((err < 0) && (errno == EINTR)) {
			continue;
		}
		if (err < 0) {
			return 0;
		}

		timeout=t;

		if (FD_ISSET(LIBGGI_SELECT_FD(vis),&fds)) {
			err=read(LIBGGI_SELECT_FD(vis),buff,BUFFER_SIZE);
			if (err<=0) 
				continue;

			for (bp=buff;err > 0;err-=*bp,bp+=*bp) 
				_ggiEvQueueAdd(vis,(ggi_event *)bp);
		
			evmask = _ggiEvQueueSeen(vis,mask);
		}
	} while (evmask==0 && t==NULL);

	return evmask;
}

int GGIeventread(ggi_visual_t vis,ggi_event *ev,ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	GGIeventpoll(vis,mask,NULL);
	return _ggiEvQueueRelease(vis,ev,mask);
}
