/* $Id: pthread.c,v 1.7 1998/10/12 00:24:31 becka Exp $
***************************************************************************

   Helper library for the implementation of SYNC mode on targets which are
   inherently ASYNC (e.g. X) and require manual flushes of the framebuffer.

   MANSYNC_PTHREAD implementation.

   Copyright (C) 1998  Steve Cheng   [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "mansync.h"

#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#include <pthread.h>


#ifndef USE_THREADS
#warning You might want to compile libGGI with multithreading support.
#endif


/* Hook structure to helperpriv of mansync visual. */

struct mansync_hook {
	int isasync;
	pthread_t thread;
};


#undef MANSYNC_ISASYNC
#define MANSYNC_PRIV(vis)	((struct mansync_hook *)vis->helperpriv)
#define MANSYNC_ISASYNC(vis)	(MANSYNC_PRIV(vis)->isasync)


static void *_GGI_mansync_thread(void *arg)
{
	ggi_visual *vis = arg;
	int retval = 0;

	while(!MANSYNC_ISASYNC(vis)) {
		DPRINT("Doing mansync-flush.\n");
		ggiFlush(vis);

		_ggi_usleep(1000000/MANSYNC_FPS);
	}
	pthread_exit(&retval);
}


int _GGI_mansync_init(ggi_visual *vis)
{
	vis->helperpriv = _ggi_malloc(sizeof(struct mansync_hook));
	MANSYNC_ISASYNC(vis) = 1;	/* Yes, this SHOULD be initialized to 1. */
	return 0;
}


int _GGI_mansync_deinit(ggi_visual *vis)
{
	_GGI_mansync_stop(vis);

	free(vis->helperpriv);
	vis->helperpriv = NULL;

	return 0;
}


int _GGI_mansync_start(ggi_visual *vis)
{
	DPRINT("_GGI_mansync_start() (MANSYNC_PTHREAD) called.\n");

	if(!MANSYNC_ISASYNC(vis))
		return -1;

	MANSYNC_ISASYNC(vis) = 0;

	if(pthread_create(&MANSYNC_PRIV(vis)->thread, NULL, _GGI_mansync_thread, vis))
		return -1;

	return 0;
}


int _GGI_mansync_stop(ggi_visual *vis)
{
	DPRINT("_GGI_mansync_stop() (MANSYNC_PTHREAD) called.\n");

	if(MANSYNC_ISASYNC(vis))
		return -1;

	/* Thread should die automatically */
	MANSYNC_ISASYNC(vis) = 1;
	
	return pthread_join(MANSYNC_PRIV(vis)->thread, NULL);
}


/* Threads can't be arbitrarily suspended so these functions
   terminate/restart the threads instead. */

int _GGI_mansync_ignore(ggi_visual *vis)
{
	return _GGI_mansync_stop(vis);
}


int _GGI_mansync_cont(ggi_visual *vis)
{
	if (LIBGGI_FLAGS(vis) & GGIFLAG_ASYNC)
		return -1;
		
	return _GGI_mansync_start(vis);
}


