/* $Id: palemu.h,v 1.8 1998/10/10 13:24:17 ajapted Exp $
***************************************************************************

   Display-palemu: palette emulation on true color modes

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _DISPLAY_PALEMU_H
#define _DISPLAY_PALEMU_H

#include <ggi/internal/ggi-dl.h>

#include "../mansync/mansync.h"


/**************************************************
 **
 **  PalEmu private defines
 **
 **************************************************/


#ifndef NULL
#define NULL  ((void *) 0L)
#endif

#ifndef MIN
#define MIN(a, b)  ((a) < (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b)  ((a) > (b) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(n)  (((n) < 0) ? -(n) : (n))
#endif


#define UPDATE_MOD(vis, x1, y1, w, h)  \
	do {                                                   \
		PalemuHook *ph = PALEMU_PRIV(vis);             \
		int x2=(x1)+(w);                               \
		int y2=(y1)+(h);                               \
                                                               \
		if ((x1) < ph->dirty_tl.x) ph->dirty_tl.x =    \
			MAX((x1), (vis)->gc->cliptl.x);        \
		if ((y1) < ph->dirty_tl.y) ph->dirty_tl.y =    \
			MAX((y1), (vis)->gc->cliptl.y);        \
		if ((x2) > ph->dirty_br.x) ph->dirty_br.x =    \
			MIN((x2), (vis)->gc->clipbr.x);        \
		if ((y2) > ph->dirty_br.y) ph->dirty_br.y =    \
			MIN((y2), (vis)->gc->clipbr.y);        \
	} while (0)


/**************************************************** 
 **
 **  PalEmu private data
 **
 ****************************************************/


typedef struct palemu_hook
{
	int flags;
	
	ggi_visual_t parent;
	ggi_mode mode;

	/* framebuffer */

	void *fb_ptr;
	long  fb_size;
	long  frame_size;
	
	/* color info */
	
	ggi_pixel *lookup;
	ggi_color *palette;

	ggi_float red_gamma;
	ggi_float green_gamma;
	ggi_float blue_gamma;

	/* 2D operations on memory buffer */

	struct ggi_visual_opdraw *mem_opdraw;

	ggi_coord dirty_tl;
	ggi_coord dirty_br;
	
	/* blitter function */

	void (* do_blit) (struct palemu_hook *ph, void *dest, 
			  void *src, int w);

	/* mansync info */

	ggi_mutex flush_lock;
	_ggi_opmansync *opmansync;

} PalemuHook;

#define PALEMU_PRIV(vis)  ((PalemuHook *) LIBGGI_PRIVATE(vis))



/****************************************************
 **
 **  PalEmu private functions
 **
 ****************************************************/
 
  
extern int _ggi_palemu_Open(ggi_visual *vis);
extern int _ggi_palemu_Close(ggi_visual *vis);
extern int _ggi_palemu_Transfer(ggi_visual*vis, int x, int y, int w, int h);
extern int _ggi_palemu_Flush(ggi_visual*vis);


/****************************************************
 **
 **  PalEmu internal interfaces
 **
 ****************************************************/
 
  
ggifunc_getmode         GGI_palemu_getmode;
ggifunc_setmode         GGI_palemu_setmode;
ggifunc_resetmode       GGI_palemu_resetmode;
ggifunc_checkmode       GGI_palemu_checkmode;
ggifunc_getapi          GGI_palemu_getapi;
ggifunc_flush           GGI_palemu_flush;
ggifunc_setflags        GGI_palemu_setflags;

ggifunc_eventpoll       GGI_palemu_eventpoll;
ggifunc_eventread       GGI_palemu_eventread;
ggifunc_seteventmask    GGIseteventmask;

ggifunc_drawpixel	GGI_palemu_drawpixel;
ggifunc_drawpixel_nc	GGI_palemu_drawpixel_nc;
ggifunc_drawhline_nc	GGI_palemu_drawhline_nc;
ggifunc_drawhline	GGI_palemu_drawhline;
ggifunc_drawvline_nc	GGI_palemu_drawvline_nc;
ggifunc_drawvline	GGI_palemu_drawvline;
ggifunc_drawline	GGI_palemu_drawline;

ggifunc_putc		GGI_palemu_putc;
ggifunc_getcharsize	GGI_palemu_getcharsize;
ggifunc_putpixel_nc	GGI_palemu_putpixel_nc;
ggifunc_putpixel	GGI_palemu_putpixel;
ggifunc_puthline	GGI_palemu_puthline;
ggifunc_putvline	GGI_palemu_putvline;

ggifunc_putbox		GGI_palemu_putbox;
ggifunc_drawbox		GGI_palemu_drawbox;
ggifunc_copybox		GGI_palemu_copybox;
ggifunc_crossblit	GGI_palemu_crossblit;
ggifunc_fillscreen	GGI_palemu_fillscreen;
ggifunc_setorigin	GGI_palemu_setorigin;
ggifunc_setpalvec	GGI_palemu_setpalvec;

ggifunc_setdisplayframe	GGI_palemu_setdisplayframe;
ggifunc_setreadframe	GGI_palemu_setreadframe;
ggifunc_setwriteframe	GGI_palemu_setwriteframe;


#define MANSYNC_init(vis)    PALEMU_PRIV(vis)->opmansync->init(vis)
#define MANSYNC_deinit(vis)  PALEMU_PRIV(vis)->opmansync->deinit(vis)
#define MANSYNC_start(vis)   PALEMU_PRIV(vis)->opmansync->start(vis)
#define MANSYNC_stop(vis)    PALEMU_PRIV(vis)->opmansync->stop(vis)
#define MANSYNC_ignore(vis)  PALEMU_PRIV(vis)->opmansync->ignore(vis)
#define MANSYNC_cont(vis)    PALEMU_PRIV(vis)->opmansync->cont(vis)


#endif  /* _DISPLAY_PALEMU_H */
