/* $Id: visual.c,v 1.11 1998/10/18 15:52:59 becka Exp $
***************************************************************************

   Display-SUID: initialization

   Copyright (C) 1995,1998 Andreas Beck   [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan      [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <signal.h>

#include <ggi/ggi_commands.h>
#include <ggi/internal/ggi-dl.h>
#include "debug.h"

int _suidtarget_dev_mem=-1;
extern struct kgi_device  mydevice;

extern int suid_kbd_fd;
extern int suid_mouse_fd;

int _isup=0;

int GGIdlcleanup(ggi_visual *vis);

static void get_killed(int signum)
{
	fprintf(stderr, "SIGNAL %d OCCURRED\n", signum);
	GGIdlcleanup(NULL);
	raise(signum);
}

int GGIflush(ggi_visual *vis)
{
	/* Mainly here to stop those annoying '_default_error' messages
	 * in the debugging output.
	 */
	return 0;
}

extern ggi_uint law_base;

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	int x,y;
	ggi_mode mode;
	void *memptr=NULL;
  
	LIBGGI_FD(vis)=LIBGGI_SELECT_FD(vis)=-1; /* There are no FDs for suidKGI. */

	/* Has mode management */
	vis->opdisplay->getmode=GGIgetmode;
	vis->opdisplay->setmode=GGIsetmode;
	vis->opdisplay->checkmode=GGIcheckmode;
	vis->opdisplay->flush=GGIflush;
	vis->opdisplay->kgicommand=GGIkgicommand;
	vis->opdisplay->setflags=GGIsetflags;

	/* Has Event management */
	vis->opdisplay->eventpoll=GGIeventpoll;
	vis->opdisplay->eventread=GGIeventread;
	vis->opdisplay->seteventmask=GGIseteventmask;

	vis->opdraw->setsplitline=GGIsetsplitline;
	vis->opdraw->setorigin   =GGIsetorigin;

	if (iopl(3)) {perror("iopl");exit(2); }
	DPRINT("IOPL is here.\n");
  
	if (-1==(_suidtarget_dev_mem=open("/dev/mem",O_RDWR))) { perror("opening /dev/mem");exit(3); }
	memptr=mmap(NULL,64*1024,PROT_READ|PROT_WRITE,MAP_SHARED,_suidtarget_dev_mem,0xa0000);
	DPRINT("Have mmap at %p.\n",memptr);

	law_base=0xf3000000;
	if (suidkgi_init_module()) {DPRINT("Init has failed. Tough luck.\n");exit(1); }

	DPRINT("Init was o.k.\n");
	signal(SIGSEGV,get_killed);
	signal(SIGINT,get_killed);
	signal(SIGTERM,get_killed);
	_isup=1;

#if 0
	/* Not sure, if this is needed, but ... */
	mode.frames=1;
	mode.graphtype=GT_TEXT16;
	mode.visible.x=mode.virt.x=80;
	mode.visible.y=mode.virt.y=25;
	mode.dpp.x = 8;mode.dpp.y =16;
	x=GGIcheckmode(vis,&mode);
	DPRINT("TESTMODE says %d.\n",x);
	x=GGIsetmode(vis,&mode);
	DPRINT("SETMODE says %d.\n",x);
#endif
#ifdef TESTING_THE_SUID_TARGET
	for(x=0;x<480;x++)
	{
		GGIsetsplitline(vis, x);
		_ggi_usleep(1000);
	}

	mode.frames=1;
	mode.graphtype=GT_8BIT;
	mode.visible.x=mode.virt.x=320;
	mode.visible.y=mode.virt.y=200;
	mode.dpp.x    =mode.dpp.y =1;
	x=GGIcheckmode(vis,&mode);
	DPRINT("TESTMODE says %d.\n",x);
	x=GGIsetmode(vis,&mode);
	DPRINT("SETMODE says %d.\n",x);

	sleep(1);

	for(y=0;y<200;y++)
	{ 
		for(x=0;x<320;x++)
		{ 
			*((unsigned char *)memptr+x+y*320)=x+y; 
		}
		_ggi_usleep(1);
	}
	sleep(1);

	mode.frames=1;
	mode.graphtype=GT_TEXT16;
	mode.visible.x=mode.virt.x=80;
	mode.visible.y=mode.virt.y=25;
	mode.dpp.x = 8;mode.dpp.y =16;
	x=GGIcheckmode(vis,&mode);
	DPRINT("TESTMODE says %d.\n",x);
	x=GGIsetmode(vis,&mode);
	DPRINT("SETMODE says %d.\n",x);

	sleep(1);

	suidkgi_cleanup_module();

	DPRINT("Cleanup went well.\n");
	close(_suidtarget_dev_mem);
	exit(1);
#endif

	return GGI_DL_OPDISPLAY|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	if (_isup)
	{
		suidkgi_cleanup_module();

		if (suid_kbd_fd >= 0) {
			fbdev_exit_keyboard(vis);
			fbdev_exit_mouse(vis);

			vtswitch_close(vis);

			suid_kbd_fd = -1;
		}

		DPRINT("Cleanup went well.\n");
		close(_suidtarget_dev_mem);
		_isup=0;
	}

	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
