/* $Id: box.c,v 1.8 1998/09/23 21:35:22 marcus Exp $
***************************************************************************

   SVGAlib target: box stubs

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgavisual.h"

/**********************/
/* draw/get/put a box */
/**********************/
int GGI_svga_drawbox(ggi_visual *vis,int x,int y,int width,int length)
{
	int x2;
  
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		length-=diff;
	}
	if (y+length>(LIBGGI_GC(vis)->clipbr.y)) {
		length=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x     +=diff;
		width-=diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}

	if (length<=0 || width<=0 ) 
		return 0;

	vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
	x2 = width+x-1;
	while(length--) {
		vga_drawline(x,y,x2,y);
		y++;
	}
	return 0;
}

int GGI_svga_putbox(ggi_visual *vis,int x,int y,int width,int length,void *buffer)
{ 
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8 * width;
	ggi_coord  tl=LIBGGI_GC(vis)->cliptl, br=LIBGGI_GC(vis)->clipbr;

	/* Pre-Clipping, so we don't call PutHline without need. */
	if (y< tl.y) {
		int diff=tl.y-y;
		y     +=diff;
		length-=diff;
		buffer = (uint8 *)(buffer)+rowadd*diff; 
	}
	if (y+length>=br.y) {
		length=br.y-y;
	}
	if (x< tl.x) {
		int diff=tl.x-x;
		x     +=diff;
		width -=diff;
		buffer = (uint8 *)(buffer)+diff;
		}
	if (x+width>=br.x) {
		width=br.x-x;
	}
	if (length<0||width<0)
		return 0;

	if (SVGA_PRIV(vis)->ismodex
		&& width%4 == 0
		&& x%4 == 0) {
		vga_copytoplanar256(buffer, rowadd, ((y*LIBGGI_MODE(vis)->virt.x+x))/4,
							LIBGGI_MODE(vis)->virt.x/4, width, length);
	} else
		while(length--) {
			ggiPutHLine(vis,x,y++,width,buffer);
			buffer= (uint8 *)(buffer)+rowadd; 
		}
	
	return 0;
}
