/* $Id: hline.c,v 1.10 1998/09/23 21:35:24 marcus Exp $
***************************************************************************

   SVGAlib target: horizontal lines

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgavisual.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_svga_drawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y))
		return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
		vga_drawline(x,y,x+w-1,y);
	}
	return 0;
}

int GGI_svga_drawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	vga_setcolor(LIBGGI_GC_FGCOLOR(vis));
	vga_drawline(x,y,x+w-1,y);
	return 0;
}

int GGI_svga_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		if (SVGA_PRIV(vis)->ismodex && x%4 != 0) {
			for (;x%4 != 0;x++) {
				ggiPutPixel(vis, x, y, *((char*)buffer));
				buffer = ((char*)buffer)+1;
			}
			for (;w%4 != 0;w--)
				ggiPutPixel(vis, x, y, *((char*)buffer+w));	
		}
        vga_drawscansegment(buffer, x, y, w*LIBGGI_PIXFMT(vis)->size/8);
	}
	return 0;
}

int GGI_svga_gethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	vga_getscansegment(buffer, x, y, w*LIBGGI_PIXFMT(vis)->size/8);
	
	return 0;
}
