/* $Id: telehook.h,v 1.5 1998/09/26 03:26:25 marcus Exp $
***************************************************************************

   TELE target.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _LIBGGI_DISPLAY_TELE_TELEHOOK_H
#define _LIBGGI_DISPLAY_TELE_TELEHOOK_H

#include "libtele.h"

#include <ggi/internal/ggi-dl.h>


typedef struct tele_hook
{
	TeleClient *client;

	int connected;
	int mode_up;
	
	TeleEvent *wait_event;

	long wait_type;
	long wait_sequence;

} TeleHook;

#define TELE_PRIV(vis)  ((TeleHook *) LIBGGI_PRIVATE(vis))


#define TELE_HANDLE_SHUTDOWN  \
	do {  \
		fprintf(stderr, "display-tele: Server GONE !\n");  \
		exit(2);  \
	} while(0)


/* internal functions */

extern int GGI_tele_resetmode(ggi_visual *vis);

extern int tele_receive_reply(ggi_visual *vis, TeleEvent *ev,
				long type, long seq);

/* Prototypes
 */

ggifunc_getmode		GGI_tele_getmode;
ggifunc_setmode		GGI_tele_setmode;
ggifunc_checkmode	GGI_tele_checkmode;
ggifunc_flush		GGI_tele_flush;
ggifunc_eventpoll	GGI_tele_eventpoll;
ggifunc_eventread	GGI_tele_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_setpalvec	GGI_tele_setpalvec;
ggifunc_putpixel_nc	GGI_tele_putpixel_nc;
ggifunc_putpixel	GGI_tele_putpixel;
ggifunc_puthline	GGI_tele_puthline;
ggifunc_putvline	GGI_tele_putvline;
ggifunc_putbox		GGI_tele_putbox;
ggifunc_getpixel	GGI_tele_getpixel;
ggifunc_gethline	GGI_tele_gethline;
ggifunc_getvline	GGI_tele_getvline;
ggifunc_getbox		GGI_tele_getbox;
ggifunc_drawpixel_nc	GGI_tele_drawpixel_nc;
ggifunc_drawpixel	GGI_tele_drawpixel;
ggifunc_drawhline_nc	GGI_tele_drawhline_nc;
ggifunc_drawhline	GGI_tele_drawhline;
ggifunc_drawvline_nc	GGI_tele_drawvline_nc;
ggifunc_drawvline	GGI_tele_drawvline;
ggifunc_drawbox		GGI_tele_drawbox;
ggifunc_copybox		GGI_tele_copybox;
ggifunc_putc		GGI_tele_putc;
ggifunc_getcharsize	GGI_tele_getcharsize;
ggifunc_setorigin	GGI_tele_setorigin;

#endif /* _LIBGGI_DISPLAY_TELE_TELEHOOK_H */
