/* $Id: hline.c,v 1.9 1998/09/25 21:33:16 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: horizontal lines

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_vgagl_drawhline(ggi_visual *vis,int x,int y,int width)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		width-=diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (width>0) {
		gl_hline(x,y,x+width-1,LIBGGI_GC_FGCOLOR(vis));
	}
	return 0;
}

int GGI_vgagl_drawhline_nc(ggi_visual *vis,int x,int y,int width)
{
	gl_hline(x,y,x+width-1,LIBGGI_GC_FGCOLOR(vis));
	return 0;
}

int GGI_vgagl_puthline(ggi_visual *vis,int x,int y,int width,void *buffer)
{ 
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		width-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (width>0) {
        gl_putbox(x, y, width, 1, buffer);
	}
	return 0;
}

int GGI_vgagl_gethline(ggi_visual *vis,int x,int y,int width,void *buffer)
{ 
	gl_getbox(x, y, width, 1, buffer);
	
	return 0;
}
