/* $Id: misctest.c,v 1.5 1998/10/29 21:36:59 becka Exp $
***************************************************************************

   Test program for the "misc" extension.

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>

#include <ggi/ggi.h>
#include <ggi/ggi_ext.h>
#include "../misc.h"

void main()
{
	ggi_visual_t vis;
	int temp;

	if (ggiInit() != 0) {
		fprintf(stderr, "unable to initialize libggi, exiting.\n");
		exit(1);
	}
	if (ggiMiscInit() != 0) {
		fprintf(stderr, "unable to initialize libggi misc-extension, exiting.\n");
		exit(1);
	}
	if ((vis=ggiOpen(NULL)) == NULL) {
		fprintf(stderr,
			"unable to open default visual, exiting.\n");
		exit(1);
	}

	ggiSetGraphMode(vis,320,200,GGI_AUTO,GGI_AUTO,GGI_AUTO);
	
	ggiMiscAttach(vis);

	ggiSetGCForeground(vis,0xffffffff);

	for(temp=0;temp<200;temp+=3) 
		ggiDrawLine(vis,0,temp,319,199-temp);

	for(temp=0;temp<200;temp++) 
	{ 
		ggiSetSplitline(vis,temp);
	}

	ggiMiscDetach(vis);

	ggiClose(vis);

	temp=ggiMiscExit();printf("MiscExit : %i\n",temp);
	temp=ggiExit();    printf("ggiExit  : %i\n",temp);
}
