/* 
 *  Fixed point macros
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __GGI_FPOINT_H
#define __GGI_FPOINT_H

/*----------------------------------------------------------------------*/

#define FP_SHIFT	16
#define FP_SCALE	(1 << FP_SHIFT)

typedef int fpoint;

#define FP_ZERO		0
#define FP_ONE		FP_SCALE
#define FP_HALF         (1 << (FP_SHIFT-1))

#define FP_FRAC_MASK	(FP_SCALE - 1) 
#define FP_INT_MASK	((-1) << FP_SHIFT)

#define FPNewInt(I)	((I) << FP_SHIFT)
#define FPNewFloat(X)	((int) ((X) * FP_SCALE))
#define FPInt(X)	((X) >> FP_SHIFT)
#define FPUInt(X)	(((uint)(X)) >> FP_SHIFT)
#define FPFracInt(X)	FPFrac(X)
#define FPFloat(X)	((X) * (1/(float)FP_SCALE)) 

#define FPMul(X,Y)	(((long long)(X)) * (Y) >> FP_SHIFT)
#define FPDiv(X,Y)	((((long long)(X)) << FP_SHIFT) / (Y))
#define FPDivInt(X,Y)	(((X) << FP_SHIFT) / (Y))
#define FPMulDiv(X,Y,Z)	(((long long)(X)) * (Y) / (Z))

#define FPAbs(X)	abs(X)
#define FPFrac(X)	((X) & FP_FRAC_MASK)
#define FPCeil(X)	FPInt(((X) + FP_FRAC_MASK) & FP_INT_MASK)
#define FPFloor(X)	FPInt((X) & FP_INT_MASK)
#define FPRound(X)	FPInt(((X) + FP_HALF) & FP_INT_MASK)

/*----------------------------------------------------------------------*/

#endif /* __GGI_FPOINT_H */
