/* 
 *  Ellipse template
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*----------------------------------------------------------------------
#define PLOT(x, y)
    plots a pixel at (x,y)

#define FILL
    filled circle
#define SCANLINE(x1, x2, y)
    fills a horizontal scanline from (x1,y) to (x2,y) 

#define STIPPLE
    use stippling 

----------------------------------------------------------------------*/

/* 
void	drawEllipse(ggi_visual_t vis, int x, int y, uint a, uint b)
void	fillEllipse(ggi_visual_t vis, int x, int y, uint a, uint b)
*/
{
/* FIXME: overflow ? */
	int	yq, dx, dy, r, s, t;
	int	z, e, f, g, h;

#ifndef	STIPPLE
	e = x - a; g = y;
	f = x + a; h = y;
#	ifndef	FILL
	PLOT(e, y);
	PLOT(f, y);
#	else
	SCANLINE(e, f, y);
#	endif
	yq = b*b; dx = a*a*2;
	dy = yq*2; r = a*yq;
	s  = r*2; t = 0; z = a;
	while (z > 0) {
		if (r > 0)	{ g++; h--; t += dx; r -= t; }
		if (r <= 0)	{ e++; f--; s -= dy; r += s; z--; }
#	ifndef	FILL
		PLOT(e, g); 
		PLOT(f, g);
		PLOT(e, h); 
		PLOT(f, h);
#	else
		SCANLINE(e, f, g);
		SCANLINE(e, f, h);
#	endif
	}
#else
#endif
}

#undef PLOT
#undef FILL
#undef SCANLINE
#undef STIPPLE
