/* 
 *  Line template
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*----------------------------------------------------------------------
macros that must be defined:
    
#define HLINE(x1, x2, y)
	draws a horizontal line from (x1,y) to (x2,y) 
#define VLINE(x, y1, y2)
	draws a vertical line from (x,y1) to (x,y2) 

#define PLOT(x, y)
	plots a pixel at (x,y)
    
options that can be defined:
	
#define STIPPLE
	stippled line

----------------------------------------------------------------------*/

/* 
void	line(ggi_visual_t vis, int x1, int y1, int x2, int y2)
*/
{
	uint	x, y;
	int	xstep;
	int	end;
	int	d;
	int	dx, dy;
/*----------------------------------------------------------------------*/
/* initialize */

	if (y1 > y2) {
		swap(x1, x2);
		swap(y1, y2);
	}
	dx = x2 - x1;
	dy = y2 - y1;
	if (dx < 0) { dx = -dx; xstep = -1; } else xstep = 1;
	x = x1; y = y1;
/*----------------------------------------------------------------------*/
/* horizontal line */

	if (dy == 0) 
		HLINE(x, x2, y);
/*----------------------------------------------------------------------*/
/* vertical line */

	else if (dx == 0)
		VLINE(x, y, y2);
/*----------------------------------------------------------------------*/
	else {
		PLOT(x, y);
/*----------------------------------------------------------------------*/
/* step in vertical direction */   

	if (dx < dy) {
		d = dy - 1; dx += dx; dy += dy;
		while (y != y2) {
			y++; d -= dx;
			if (d < 0) { d += dy; x += xstep; }
			PLOT(x, y);
		}
	} else 
/*----------------------------------------------------------------------*/
/* step in horizontal direction */   

	if (dx > dy) {	
		d = dx - 1; dx += dx; dy += dy; end = x2;
		while (x != end) {
			x += xstep; d -= dy;
			if (d < 0) { d += dx; y++; }
			PLOT(x, y);
		}
	} else 
/*----------------------------------------------------------------------*/
/* diagonal line */
	{
		end = y2;
		while (y != end) {
			x += xstep; y++;
			PLOT(x, y);
		}
	}
/*----------------------------------------------------------------------*/
	}
}

#undef HLINE
#undef VLINE
#undef PLOT
