/* 
 *  API stubs
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "internal2d.h"

/*----------------------------------------------------------------------*/

/* drawing functions */

#define	CALL(vis,f)	\
	_ggiLock(vis->mutex);\
	GGI2D_FUNC(vis)->f;\
	_ggiUnlock(vis->mutex);\
        return 0;

int	ggi2dPutPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel color)
{	CALL(vis,putPixel(vis, x, y, color))	}

int	ggi2dDrawPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{	CALL(vis,drawPixel(vis, x, y)) }

int	ggi2dFillPixel(ggi_visual_t vis, ggi_sint x, ggi_sint y)
{	CALL(vis,fillPixel(vis, x, y)) }

int	ggi2dDrawPixels(ggi_visual_t vis, ggi2d_coord coords[], 
			ggi_uint count)
{	CALL(vis,drawPixels(vis, coords, count)) }

int	ggi2dScanLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{	CALL(vis,scanline(vis, x1, x2, y)) }

int	ggi2dScanLines(ggi_visual_t vis, ggi2d_scanline scanlines[], 
			ggi_uint count)
{	CALL(vis,scanlines(vis, scanlines, count)) }

int	ggi2dHLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{	CALL(vis,hLine(vis, x1, x2, y)) }

int	ggi2dVLine(ggi_visual_t vis, ggi_sint x, ggi_sint y1, ggi_sint y2)
{	CALL(vis,vLine(vis, x, y1, y2)) }

int	ggi2dDrawRect(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, 
			ggi_sint x2, ggi_sint y2)
{	CALL(vis,drawRect(vis, x1, y1, x2, y2)) }

int	ggi2dFillRect(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, 
			ggi_sint x2, ggi_sint y2)
{	CALL(vis,fillRect(vis, x1, y1, x2, y2)) }

int	ggi2dLine(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{	CALL(vis,line(vis, x1, y1, x2, y2)) }

int	ggi2dDrawLines(ggi_visual_t vis, ggi2d_line lines[], ggi_uint count)
{	CALL(vis,drawLines(vis, lines, count)) }

int	ggi2dDrawCircle(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r)
{	CALL(vis,drawCircle(vis, x, y, r)) }

int	ggi2dFillCircle(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r)
{	CALL(vis,fillCircle(vis, x, y, r)) }

int	ggi2dDrawEllipse(ggi_visual_t vis, ggi_sint x, ggi_sint y, 
			ggi_uint rx, ggi_uint ry)
{	CALL(vis,drawEllipse(vis, x, y, rx, ry)) }

int	ggi2dFillEllipse(ggi_visual_t vis, ggi_sint x, ggi_sint y, 
			ggi_uint rx, ggi_uint ry)
{	CALL(vis,fillEllipse(vis, x, y, rx, ry)) }

int	ggi2dDrawArc(ggi_visual_t vis, ggi_sint x, ggi_sint y, 
			ggi_uint rx, ggi_uint ry, 
			ggi_float start, ggi_float end, int close)
{	CALL(vis,drawArc(vis, x, y, rx, ry, start, end, close)) }

int	ggi2dFillArc(ggi_visual_t vis, ggi_sint x, ggi_sint y, 
			ggi_uint rx, ggi_uint ry, 
			ggi_float start, ggi_float end)
{	CALL(vis,fillArc(vis, x, y, rx, ry, start, end)) }

int	ggi2dBezier(ggi_visual_t vis, 
			ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2, 
			ggi_sint x3, ggi_sint y3, ggi_sint x4, ggi_sint y4)
{	CALL(vis,bezier(vis, x1, y1, x2, y2, x3, y3, x4, y4)) }

int	ggi2dTrapezoid(ggi_visual_t vis, ggi_sint xl1, ggi_sint xr1, 
			ggi_sint y1, ggi_sint xl2, ggi_sint xr2, ggi_sint y2)
{	CALL(vis,trapezoid(vis, xl1, xr1, y1, xl2, xr2, y2)) }

int	ggi2dTriangle(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, 
			ggi_sint x2, ggi_sint y2, ggi_sint x3, ggi_sint y3)
{	CALL(vis,triangle(vis, x1, y1, x2, y2, x3, y3)) }

int	ggi2dDrawPoly(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count)
{	CALL(vis,drawPoly(vis, coords, count)) }

int	ggi2dFillPoly(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count)
{	CALL(vis,fillPoly(vis, coords, count)) }

int	ggi2dFillPolys(ggi_visual_t vis, ggi2d_coord coords[], 
			ggi_uint counts[], ggi_uint count)
{	CALL(vis,fillPolys(vis, coords, counts, count)) }

int	ggi2dBlit(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi2d_image src, ggi_sint sx, ggi_sint sy, 
			ggi_sint width, ggi_sint height)
{	CALL(vis,blit(vis, dx, dy, src, sx, sy, width, height)) }

int	ggi2dStretchBlit(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi_sint dwidth, ggi_sint dheight, 
			ggi2d_image src, ggi_sint sx, ggi_sint sy, 
			ggi_sint swidth, ggi_sint sheight)
{	CALL(vis,stretchBlit(vis, dx, dy, dwidth, dheight, 
			src, sx, sy, swidth, sheight)) }

int	ggi2dBlitOp(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
			ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
			ggi_sint width, ggi_sint height, ggi2d_operator op)
{	CALL(vis,blitOp(vis, dx, dy, src1, s1x, s1y, src2, s2x, s2y, 
			width, height, op)) }

int	ggi2dStretchBlitOp(ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
			ggi_sint dwidth, ggi_sint dheight, 
			ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
			ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
			ggi_sint swidth, ggi_sint sheight, ggi2d_operator op)
{	CALL(vis,stretchBlitOp(vis, dx, dy, dwidth, dheight,
			src1, s1x, s1y,	src2, s2x, s2y, 
			swidth, sheight, op)) }

