/* 
 *  setup
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"

static void update(ggi_visual_t vis, ggi_uint change)
{
	ggi3d_funcs *func = GGI3D_FUNC(vis);

	printf("updating 3d stubs\n");

	func->triangle = GGIEXP(triangle);
}

int GGILIB_INIT(ggi_visual_t visual, const char *version)
{
	printf("initializing 3D stubs\n");
	
	GGI3DRegisterUpdateFunc(visual, update, GGI3D_UPD_ALL);
	
	return 0;
}

int GGILIB_CLEANUP(ggi_visual_t visual)
{
	return 0;
}
