/* $Id: gg.h,v 1.1 1998/10/24 04:04:14 marcus Exp $
***************************************************************************
  
   LibGG - API header file
  
   1998 Marcus Sundberg		[marcus@ggi-project.org]
   
***************************************************************************
*/

#ifndef _GGI_GG_H
#define _GGI_GG_H

#include <ggi/errors.h>
 
/*
***************************************************************************
 Library configuration handling
***************************************************************************
*/

int ggLoadConfig(const char *file, void **confret);

void ggFreeConfig(void *conf);

const char *ggMatchConfig(void *conf, const char *name, const char *ver);


/*
***************************************************************************
 Parsing functions
***************************************************************************
*/

char *ggParseTarget(char *str, char *target, int max);

#define MAX_OPTION_NAME    32
#define MAX_OPTION_RESULT  256

typedef struct gg_option
{
	char name[MAX_OPTION_NAME];
	char result[MAX_OPTION_RESULT];
} gg_option;

char *ggParseOptions(char *str, gg_option *optlist, int count);


/*
***************************************************************************
 Debug output
***************************************************************************
*/

void ggDPrintf(int sync, const char *file, int line, const char *form, ...);

#endif /* _GGI_GG_H */
