/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: private.c,v $
 * Revision 1.3  1998/08/23 18:57:13  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.2  1998/08/11 22:17:35  ortalo
 * Adapted to the gwt.h->ggi/gwt.h change. Incorporated the modifications
 * brought by Tristan Wibberley.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#include "ggi/gwt.h"
#include "internal.h"

int gwtGetPrivate(gwt_window_t win, void* *priv) {
	gwt_lock();
	*priv = win->priv;
	gwt_unlock();
	return 0;
}

int gwtSetPrivate(gwt_window_t win, void* priv) {
	gwt_lock();
	win->priv = priv;
	gwt_unlock();
	return 0;
}
