/* Demonstrates how to create C arrays  that are callable from S-Lang */
#include "config.h"
#include <stdio.h>
#include <slang.h>

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
/* Here is a global C array that will be accessed from S-Lang */
double C_Array[100];

/* Function to quit */
static void c_quit (void)
{
   exit (0);
}

static void c_exit (int *code)
{
   exit (*code);
}

/* Create the Table that S-Lang requires */
static SLang_Intrin_Fun_Type Demo_Intrinsics[] =
{
   MAKE_INTRINSIC_I(".exit", c_exit, VOID_TYPE),
   MAKE_INTRINSIC_0(".quit", c_quit, VOID_TYPE),
   SLANG_END_TABLE
};


int main (int argc, char **argv)
{
   
   char *file;
   
   if (argc != 2) 
     {
	fprintf (stderr, "Usage: %s FILENAME\n", argv[0]);
	return 1;
     }
   
   file = argv[1];
   
   /* Initialize the library.  This is always needed. */
   
   if ((-1 == SLang_init_slang ())    /* basic interpreter functions */
       || (-1 == SLang_init_slmath ()) 	       /* sin, cos, etc... */
#ifdef unix
       || (-1 == SLang_init_slunix ())	       /* unix system calls */
#endif
       || (-1 == SLang_init_slfile ())	       /* file i/o */
	  
	  /* Now add intrinsics for this application */
       || (-1 == SLadd_intrin_fun_table (Demo_Intrinsics, NULL)))
     {
	fprintf(stderr, "Unable to initialize S-Lang.\n");
	return 1;
     }

   /* Now declare the array to S-Lang.  Lets let it be known 2 ways:
    *   1. As a read/write array called: Vector
    *   2. As a read-only array called: Vector_Read_Only
    */
   
   if ((-1 == SLang_add_intrinsic_array ("Vector",   /* slang name */
					 SLANG_DOUBLE_TYPE,
					 0,   /* not read-only */
					 (VOID_STAR) C_Array,
					 1,/* number of dimensions */
					 100/* num elements in 1st dir */
					 ))
       
       || 
       (-1 == SLang_add_intrinsic_array ("Vector_Read_Only",   /* slang name */
					 SLANG_DOUBLE_TYPE,
					 1,   /* read-only */
					 (VOID_STAR) C_Array,
					 1,/* number of dimensions */
					 100/* num elements in 1st dir */
					 )))
     {
	fprintf(stderr, "Failed to add arrays\n");
	return 1;
     }
       
   
   /* Code here to do something in C to the arrays, e.g., initialize them */
   
   
   /* Turn on debugging */
   SLang_Traceback = 1;
   
   /* Now load an initialization file and exit */
   SLang_load_file (file);
   
   return (SLang_Error);
}

   

   
