/*
 * fmtest.c
 *
 *  Programmed by Hirotsugu KAKUGAWA, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 * Edition History
 *  04 Apr 1996  
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1996 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * VFlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * VFlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with VFlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "../src/config.h"
#include "../src/VF.h"

void usage(void);

int
main(argc, argv)
  int  argc;
  char **argv;
{
  int     XDots, YDots, XBytes, Fd; 
  char    *Vfcap, *Ent, *Buff;

  Vfcap = NULL;
  XDots = 100;
  YDots = 100;

  XBytes = (XDots+7)/8;
  if ((Buff = malloc(XBytes*YDots)) == NULL){
    fprintf(stderr, "malloc err\n");
    exit(0);
  }

  argv++;
  argc--;
  while (argc > 0){
    if (argv[0][0] == '-'){
      switch (argv[0][1]){
      case 'v':
	if (--argc == 0)
	  usage();
	Vfcap = *(++argv);
	break;
      default:
      case 'h':
	usage();
      }
    } else
      break;
    argc--;
    argv++;
  }

  printf("Initializing VFlib: \n");
  if (VF_Init(Vfcap) < 0){
    printf("Failed\n");
    exit(1);
  }
  printf("OK\n");

  while (argc > 0){
    Ent = argv[0];
    printf("*** Opening Font: %s\n", Ent);
    if ((Fd = VF_OpenFont(Ent)) < 0){
      printf(" ==> Failed\n");
      exit(-1);
    }
    printf(" ==> OK (fd=%d)\n", Fd);

    bzero(Buff, XBytes*YDots);
    VF_GetBitmap(0x3026, Fd, XDots, YDots, XBytes, 0, Buff);
    /* 0x3026 ==> JIS char (`LOVE' in English) */

    argv++;
    argc--;
  }
  
  VF_Deinit();

  return 0;
}

void usage(void)
{
  printf("fmest  - a test program for dynamic open/close feafure of VFlib.\n");
  printf("Usage fmtest [options] font-entry1 font-entry2 ...\n");
  printf("Options: \n");
  printf(" -v       : set vfontcap file. (must be full path name)\n");	
  exit(0);
}

/*EOF*/
