/*								-*- C++ -*-
 * $Id: DAT_typetree.cpp,v 1.2 1996-11-19 13:30:23+01 mho Exp $
 *
 * Purpose: type tree
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DAT_typetree.h"
#endif

#define  Uses_wxTypeTree
#include "wx.h"

typedef struct {
    WXTYPE my_type;
    WXTYPE parent_type;
    char   *my_name;
} wxInitType;

static wxInitType init_types[] = {

    { wxTYPE_WINDOW,		wxTYPE_ANY,		"window"},

    { wxTYPE_PANEL,		wxTYPE_WINDOW,		"panel"},
    { wxTYPE_FRAME,		wxTYPE_PANEL,		"frame"},
    { wxTYPE_DIALOG_BOX,	wxTYPE_FRAME,		"dialog box"},
    { wxTYPE_ENHANCED_DIALOG,	wxTYPE_DIALOG_BOX,	"enhanced dialog"},

    { wxTYPE_BUTTON,		wxTYPE_ITEM,		"button"},
    { wxTYPE_BUTTONBAR,		wxTYPE_TOOLBAR,		"buttonbar"},
    { wxTYPE_CHECK_BOX,		wxTYPE_ITEM,		"check box"},
    { wxTYPE_CHOICE,		wxTYPE_ITEM,		"choice"},
    { wxTYPE_CANVAS,		wxTYPE_ITEM,		"canvas"},
    { wxTYPE_GAUGE,		wxTYPE_ITEM,		"gauge"},
    { wxTYPE_GROUP_BOX,		wxTYPE_ITEM,		"group box"},
    { wxTYPE_ITEM,		wxTYPE_WINDOW,		"item"},
    { wxTYPE_LIST_BOX,		wxTYPE_ITEM,		"list box"},
    { wxTYPE_MENU,		wxTYPE_ANY,		"menu"},
    { wxTYPE_MENU_BAR,		wxTYPE_ITEM,		"menu bar"},
    { wxTYPE_MESSAGE,		wxTYPE_ITEM,		"message"},
    { wxTYPE_MULTI_TEXT,	wxTYPE_TEXT,		"multi text"},
    { wxTYPE_RADIO_BOX,		wxTYPE_ITEM,		"radio box"},
    { wxTYPE_SCROLL_BAR,	wxTYPE_ITEM,		"scrollbar"},
    { wxTYPE_SLIDER,		wxTYPE_ITEM,		"slider"},
    { wxTYPE_TEXT,		wxTYPE_ITEM,		"text"},
    { wxTYPE_TEXT_WINDOW,	wxTYPE_TEXT,		"text window"},
    { wxTYPE_TOOLBAR,		wxTYPE_ITEM,		"toolbar"},
    { wxTYPE_VIRT_LIST_BOX,	wxTYPE_ITEM,		"virtual list box"},

    { wxTYPE_EVENT,		wxTYPE_ANY,		"event"},
    { wxTYPE_COMMAND_EVENT,	wxTYPE_EVENT,		"command event"},
    { wxTYPE_KEY_EVENT,		wxTYPE_EVENT,		"key event"},
    { wxTYPE_MOUSE_EVENT,	wxTYPE_EVENT,		"mouse event"},

    { wxTYPE_DC,		wxTYPE_ANY,		"device context"},
    { wxTYPE_DC_WINDOW,		wxTYPE_DC,		"window device context"},
    { wxTYPE_DC_MEMORY,		wxTYPE_DC_CANVAS,	"memory device context"},
    { wxTYPE_DC_METAFILE,	wxTYPE_DC,		"metafile device context"},
    { wxTYPE_DC_POSTSCRIPT,	wxTYPE_DC,		"PostScript device context"},
    { wxTYPE_DC_PRINTER,	wxTYPE_DC,		"printer device context"},
    { wxTYPE_DC_SCREEN,		wxTYPE_DC_CANVAS,	"screen device context"},

    { wxTYPE_BITMAP,		wxTYPE_ANY,		"bitmap"},
    { wxTYPE_BRUSH,		wxTYPE_ANY,		"brush"},
    { wxTYPE_COLOUR,		wxTYPE_ANY,		"colour"},
    { wxTYPE_CURSOR,		wxTYPE_BITMAP,		"cursor"},
    { wxTYPE_PEN,		wxTYPE_ANY,		"pen"},
    { wxTYPE_FONT,		wxTYPE_ANY,		"font"},
    { wxTYPE_ICON,		wxTYPE_BITMAP,		"icon"},
    { wxTYPE_METAFILE,		wxTYPE_ANY,		"metafile"},
    { wxTYPE_TIMER,		wxTYPE_ANY,		"timer"},

    { wxTYPE_APP,		wxTYPE_ANY,		"application"},

    { wxTYPE_HASH_TABLE,	wxTYPE_ANY,		"hash table"},
    { wxTYPE_LIST,		wxTYPE_ANY,		"list"},
    { wxTYPE_NODE,		wxTYPE_ANY,		"node"},
    { wxTYPE_STRING_LIST,	wxTYPE_LIST,		"string list"},

    { wxTYPE_DDE_SERVER,	wxTYPE_ANY,		"DDE server"},
    { wxTYPE_DDE_CLIENT,	wxTYPE_ANY,		"DDE client"},
    { wxTYPE_DDE_CONNECTION,	wxTYPE_ANY,		"DDE connection"},
    { wxTYPE_HELP_INSTANCE,	wxTYPE_ANY,		"wxHelp instance"},

    { wxTYPE_DATABASE,		wxTYPE_ANY,		"ODBC database"},
    { wxTYPE_RECORDSET,		wxTYPE_ANY,		"ODBC recordset"},
    { wxTYPE_QUERY_FIELD,	wxTYPE_ANY,		"ODBC query field"},
    { wxTYPE_QUERY_COL,		wxTYPE_ANY,		"ODBC query col"},

};

void wxInitStandardTypes(void)
{
    // Define explicit type hierarchy
    for (unsigned int i=0; i < wxNumberOf(init_types); ++i)
	wxAllTypes.AddType(init_types[i].my_type,
			   init_types[i].parent_type,
			   init_types[i].my_name);
}

//-----------------------------------------------------------------------------
// wxTypeDef implementation
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxTypeDef, wxObject)

#if WXDEBUG

void wxTypeDef::Dump(ostream& str)
{
    str << "Typedef for " << name                  << "(" << type   << ") "
	<< "parent = "    << wxGetTypeName(parent) << "(" << parent << ")";
}

#endif

//-----------------------------------------------------------------------------
// wxTypeTree implementation
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxTypeTree, wxList)

wxTypeTree::wxTypeTree(void) : wxList(wxKEY_INTEGER)
{
    DeleteContents(TRUE);

    wxInitStandardTypes();
}

wxTypeTree::~wxTypeTree(void)
{
}

void wxTypeTree::AddType(WXTYPE type, WXTYPE parent, char *name)
{
    wxTypeDef *type_def = wxNEW wxTypeDef;
    type_def->type   = type;
    type_def->parent = parent;
    type_def->name   = name;
    Append(type, type_def);
}

//-----------------------------------------------------------------------------
// global functions to get type infos
//-----------------------------------------------------------------------------

Bool wxSubType(WXTYPE type1, WXTYPE type2)
{
    if (type1 == type2)
	return TRUE;

    WXTYPE t = type1;
    while (TRUE) {
	wxNode    *node = wxAllTypes.Find(t);
	wxTypeDef *typ  = (wxTypeDef*)(node ? node->Data() : NULL);
	if (!typ)
	    return FALSE;
	if (type2 == typ->parent)
	    return TRUE;
	t = typ->parent;
    }
}

char *wxGetTypeName(WXTYPE type)
{
    if (type == wxTYPE_ANY)
	return "any";
    wxNode    *node = wxAllTypes.Find(type);
    wxTypeDef *typ  = (wxTypeDef*)(node ? node->Data() : NULL);
    if (!typ)
	return NULL;
    return typ->name;
}
